/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;

public class AccountAutoCreateDefaultsMaintainableImpl
extends FinancialSystemMaintainable {
    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        boolean isNew = document.isNew();
        for (Section section : sections) {
            for (Row row : section.getRows()) {
                ArrayList<Field> updatedFields = new ArrayList<Field>();
                for (Field field : row.getFields()) {
                    if (this.isReadOnly(field, isNew)) {
                        field.setReadOnly(true);
                    }
                    if (!this.shouldIncludeField(field)) continue;
                    updatedFields.add(field);
                }
                row.setFields(updatedFields);
            }
        }
        return sections;
    }

    private boolean isReadOnly(Field field, boolean isNew) {
        return "kcUnit".equals(field.getPropertyName()) && !isNew;
    }

    private boolean shouldIncludeField(Field field) {
        return true;
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        AccountAutoCreateDefaults newAcctAuto = (AccountAutoCreateDefaults)document.getNewMaintainableObject().getBusinessObject();
        newAcctAuto.setKcUnit("");
        newAcctAuto.setKcUnitName("");
    }
}

