/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import java.sql.Date;
import java.util.LinkedHashMap;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.Award;
import org.kuali.kfs.module.external.kc.businessobject.Proposal;
import org.kuali.kfs.module.external.kc.dto.AwardAccountDTO;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class AwardAccount
implements ContractsAndGrantsBillingAwardAccount,
MutableInactivatable {
    private Long proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String principalId;
    private boolean active = true;
    private boolean newCollectionRecord;
    private boolean federalSponsor;
    private boolean finalBilledIndicator;
    private Date currentLastBilledDate;
    private Date previousLastBilledDate;
    private Account account;
    private Chart chartOfAccounts;
    private Person projectDirector;
    private Award award;

    public AwardAccount() {
    }

    public AwardAccount(AwardAccountDTO awardAccountDTO, String accountNumber, String chartOfAccountsCode, String cfdaNumber) {
        try {
            this.projectDirector = (Person)((PersonService)SpringContext.getBean(PersonService.class)).getPersonImplementationClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Proposal proposal = new Proposal();
        Award award = new Award();
        Agency agency = new Agency();
        Agency primeAgency = new Agency();
        this.setAccountNumber(accountNumber);
        this.setChartOfAccountsCode(chartOfAccountsCode);
        this.setPrincipalId(awardAccountDTO.getProjectDirector());
        this.setProposalNumber(awardAccountDTO.getAwardId());
        this.setActive(true);
        this.setFederalSponsor(awardAccountDTO.isFederalSponsor());
        award.setAwardNumber(awardAccountDTO.getProposalNumber());
        award.setProposalNumber(awardAccountDTO.getAwardId());
        award.setAgencyNumber(awardAccountDTO.getSponsorCode());
        award.setAwardTitle(awardAccountDTO.getAwardTitle());
        award.setGrantNumber(awardAccountDTO.getGrantNumber());
        award.setCfdaNumber(cfdaNumber);
        proposal.setFederalPassThroughAgencyNumber(awardAccountDTO.getProposalFederalPassThroughAgencyNumber());
        proposal.setProposalNumber(awardAccountDTO.getAwardId());
        proposal.setAward(award);
        this.setAward(award);
        this.getAward().setProposal(proposal);
        agency.setAgencyNumber(awardAccountDTO.getSponsorCode());
        agency.setReportingName(awardAccountDTO.getSponsorName());
        primeAgency.setAgencyNumber(awardAccountDTO.getPrimeSponsorCode());
        primeAgency.setReportingName(awardAccountDTO.getPrimeSponsorName());
        this.getAward().setAgency(agency);
        this.getAward().setPrimeAgency(primeAgency);
        this.finalBilledIndicator = awardAccountDTO.isFinalBill();
        this.currentLastBilledDate = !ObjectUtils.isNull((Object)awardAccountDTO.getLastBilledDate()) ? new Date(awardAccountDTO.getLastBilledDate().getTime()) : null;
        this.previousLastBilledDate = !ObjectUtils.isNull((Object)awardAccountDTO.getPreviousLastBilledDate()) ? new Date(awardAccountDTO.getPreviousLastBilledDate().getTime()) : null;
    }

    public Long getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(Long proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public Account getAccount() {
        return this.account;
    }

    @Deprecated
    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Person getProjectDirector() {
        this.projectDirector = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.principalId, this.projectDirector);
        return this.projectDirector;
    }

    @Deprecated
    public void setProjectDirector(Person projectDirector) {
        this.projectDirector = projectDirector;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.proposalNumber != null) {
            m.put("proposalNumber", this.proposalNumber.toString());
        }
        m.put("chartOfAccountsCode", this.chartOfAccountsCode);
        m.put("accountNumber", this.accountNumber);
        m.put("principalId", this.principalId);
        m.put("active", this.active);
        m.put("federalSponsor", this.federalSponsor);
        m.put("newCollectionRecord", this.newCollectionRecord);
        return m;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = true;
    }

    public String getProjectDirectorName() {
        if (!ObjectUtils.isNull((Object)this.getProjectDirector())) {
            return this.getProjectDirector().getName();
        }
        return null;
    }

    public void prepareForWorkflow() {
    }

    public void refresh() {
    }

    public boolean isNewCollectionRecord() {
        return false;
    }

    public void setNewCollectionRecord(boolean newCollectionRecord) {
        this.newCollectionRecord = newCollectionRecord;
    }

    public boolean isFederalSponsor() {
        return this.federalSponsor;
    }

    public void setFederalSponsor(boolean federalSponsor) {
        this.federalSponsor = federalSponsor;
    }

    public Date getCurrentLastBilledDate() {
        return this.currentLastBilledDate;
    }

    public Date getPreviousLastBilledDate() {
        return this.previousLastBilledDate;
    }

    public boolean isFinalBilledIndicator() {
        return this.finalBilledIndicator;
    }
}

