/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.Award;
import org.kuali.kfs.module.external.kc.businessobject.AwardFundManager;
import org.kuali.kfs.module.external.kc.businessobject.AwardOrganization;
import org.kuali.kfs.module.external.kc.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFund;
import org.kuali.kfs.module.external.kc.businessobject.Proposal;
import org.kuali.kfs.module.external.kc.dto.AwardDTO;
import org.kuali.kfs.module.external.kc.dto.AwardFieldValuesDto;
import org.kuali.kfs.module.external.kc.dto.AwardSearchCriteriaDto;
import org.kuali.kfs.module.external.kc.service.AccountDefaultsService;
import org.kuali.kfs.module.external.kc.service.BillingFrequencyService;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.AwardWebSoapService;
import org.kuali.kra.external.award.AwardWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AwardServiceImpl
implements ExternalizableLookupableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(AwardServiceImpl.class);
    protected AccountDefaultsService accountDefaultsService;
    protected BillingFrequencyService billingFrequencyService;
    protected ConfigurationService configurationService;
    protected ParameterService parameterService;
    protected PersonService personService;

    protected AwardWebService getWebService() {
        AwardWebService awardWebService = (AwardWebService)GlobalResourceLoader.getService((QName)KcConstants.Award.SERVICE);
        if (awardWebService == null) {
            LOG.warn((Object)"Couldn't get AwardWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            AwardWebSoapService ss = null;
            try {
                ss = new AwardWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize AwardWebSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize AwardWebSoapService: " + ex.getMessage());
            }
            awardWebService = ss.getAwardWebServicePort();
        }
        return awardWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        AwardDTO dto = this.getWebService().getAward((Long)primaryKeys.get("proposalNumber"));
        return this.awardFromDTO(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<AwardDTO> result = null;
        AwardFieldValuesDto criteria = new AwardFieldValuesDto();
        Object awardId = fieldValues.get("proposalNumber");
        if (awardId instanceof String) {
            criteria.setAwardId(Long.parseLong((String)awardId));
        } else {
            criteria.setAwardId((Long)awardId);
        }
        criteria.setAwardNumber((String)fieldValues.get("awardNumber"));
        criteria.setChartOfAccounts((String)fieldValues.get("chartOfAccountsCode"));
        criteria.setAccountNumber((String)fieldValues.get("accountNumber"));
        criteria.setPrincipalInvestigatorId((String)fieldValues.get("principalId"));
        try {
            result = this.getWebService().getMatchingAwards(criteria);
        }
        catch (WebServiceException ex) {
            LOG.error((Object)"Access to the web service is unreachable: ", (Throwable)ex);
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        ArrayList<Award> awards = new ArrayList<Award>();
        for (AwardDTO dto : result) {
            awards.add(this.awardFromDTO(dto));
        }
        return awards;
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List<AwardDTO> result = null;
        AwardSearchCriteriaDto criteria = new AwardSearchCriteriaDto();
        criteria.setAwardId(fieldValues.get("proposalNumber"));
        criteria.setAwardNumber(fieldValues.get("awardNumber"));
        criteria.setChartOfAccounts(fieldValues.get("chartOfAccountsCode"));
        criteria.setAccountNumber(fieldValues.get("accountNumber"));
        criteria.setPrincipalInvestigatorId(fieldValues.get("principalId"));
        criteria.setSponsorCode(fieldValues.get("agencyNumber"));
        criteria.setStartDate(fieldValues.get("awardBeginningDate"));
        criteria.setStartDateLowerBound(fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate"));
        criteria.setEndDate(fieldValues.get("awardEndingDate"));
        criteria.setEndDateLowerBound(fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate"));
        criteria.setBillingFrequency(fieldValues.get("awardBillingFrequency"));
        criteria.setAwardTotal(fieldValues.get("awardTotal"));
        try {
            result = this.getWebService().searchAwards(criteria);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        ArrayList<Award> awards = new ArrayList<Award>();
        for (AwardDTO dto : result) {
            awards.add(this.awardFromDTO(dto));
        }
        return awards;
    }

    protected Award awardFromDTO(AwardDTO kcAward) {
        AccountAutoCreateDefaults defaults;
        Award award = new Award();
        award.setProposalNumber(kcAward.getAwardId());
        award.setAwardNumber(kcAward.getAwardNumber());
        award.setAwardBeginningDate(kcAward.getAwardStartDate() == null ? null : new Date(kcAward.getAwardStartDate().getDate()));
        award.setAwardEndingDate(kcAward.getAwardEndDate() == null ? null : new Date(kcAward.getAwardEndDate().getDate()));
        award.setAwardTotalAmount(kcAward.getAwardTotalAmount());
        award.setAwardDirectCostAmount(kcAward.getAwardDirectCostAmount());
        award.setAwardIndirectCostAmount(kcAward.getAwardIndirectCostAmount());
        award.setAwardDocumentNumber(kcAward.getAwardDocumentNumber());
        award.setAwardLastUpdateDate(kcAward.getAwardLastUpdateDate() == null ? null : new Timestamp(kcAward.getAwardLastUpdateDate().getDate()));
        award.setAwardCreateTimestamp(kcAward.getAwardCreateTimestamp() == null ? null : new Timestamp(kcAward.getAwardCreateTimestamp().getDate()));
        award.setProposalAwardTypeCode(kcAward.getProposalAwardTypeCode());
        award.setAwardStatusCode(kcAward.getAwardStatusCode());
        award.setAgencyNumber(kcAward.getSponsorCode());
        award.setAwardTitle(kcAward.getTitle());
        award.setAgency(new Agency(kcAward.getSponsor()));
        if (kcAward.getProposal() != null) {
            award.setProposal(new Proposal(kcAward.getProposal()));
            award.getProposal().setAward(award);
        }
        award.setAdditionalFormsRequiredIndicator(kcAward.isAdditionalFormsRequired());
        award.setAutoApproveIndicator(kcAward.isAutoApproveInvoice());
        award.setMinInvoiceAmount(kcAward.getMinInvoiceAmount());
        award.setAdditionalFormsDescription(kcAward.getAdditionalFormsDescription());
        award.setStopWorkIndicator(kcAward.isStopWork());
        award.setStopWorkReason(kcAward.getStopWorkReason());
        award.setInvoicingOptionCode(kcAward.getInvoicingOption());
        award.setInvoicingOptionDescription(kcAward.getInvoicingOptionDescription());
        award.setDunningCampaign(kcAward.getDunningCampaignId());
        if (StringUtils.isNotEmpty((String)kcAward.getFundManagerId())) {
            award.setAwardPrimaryFundManager(new AwardFundManager(award.getProposalNumber(), kcAward.getFundManagerId()));
        }
        if ((defaults = this.getAccountDefaultsService().getAccountDefaults(kcAward.getUnitNumber())) != null) {
            AwardOrganization awardOrg = new AwardOrganization();
            awardOrg.setActive(true);
            awardOrg.setAwardPrimaryOrganizationIndicator(true);
            awardOrg.setChartOfAccountsCode(defaults.getChartOfAccountsCode());
            awardOrg.setChartOfAccounts(defaults.getChartOfAccounts());
            awardOrg.setOrganization(defaults.getOrganization());
            awardOrg.setOrganizationCode(defaults.getOrganizationCode());
            awardOrg.setProposalNumber(award.getProposalNumber());
            award.setPrimaryAwardOrganization(awardOrg);
        }
        if (kcAward.getMethodOfPayment() != null) {
            award.setLetterOfCreditFundCode(kcAward.getMethodOfPayment().getMethodOfPaymentCode());
            award.setLetterOfCreditFund(new LetterOfCreditFund(kcAward.getMethodOfPayment().getMethodOfPaymentCode(), kcAward.getMethodOfPayment().getDescription()));
        }
        award.setBillingFrequency(this.getBillingFrequencyService().createBillingFrequency(kcAward.getInvoiceBillingFrequency()));
        award.setAwardPrimaryProjectDirector(this.getProjectDirector(kcAward));
        award.setExcludedFromInvoicing(kcAward.isExcludedFromInvoicing());
        award.setExcludedFromInvoicingReason(kcAward.getExcludedFromInvoicingReason());
        return award;
    }

    protected AwardProjectDirector getProjectDirector(AwardDTO kcAward) {
        AwardProjectDirector director = new AwardProjectDirector();
        director.setPrincipalId(kcAward.getPrincipalInvestigatorId());
        director.setProjectDirector(this.getPersonService().getPerson(kcAward.getPrincipalInvestigatorId()));
        director.setProposalNumber(kcAward.getAwardId());
        return director;
    }

    protected AccountDefaultsService getAccountDefaultsService() {
        return this.accountDefaultsService;
    }

    public void setAccountDefaultsService(AccountDefaultsService accountDefaultsService) {
        this.accountDefaultsService = accountDefaultsService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected BillingFrequencyService getBillingFrequencyService() {
        return this.billingFrequencyService;
    }

    public void setBillingFrequencyService(BillingFrequencyService billingFrequencyService) {
        this.billingFrequencyService = billingFrequencyService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

