/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebParam;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableDunningCampaign;
import org.kuali.kfs.integration.cg.dto.HashMapElement;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.external.kc.dto.DunningCampaignDTO;
import org.kuali.kfs.module.external.kc.service.DunningCampaignService;

public class DunningCampaignServiceImpl
implements DunningCampaignService {
    protected static Logger LOG = Logger.getLogger(DunningCampaignServiceImpl.class);

    @Override
    public DunningCampaignDTO getDunningCampaign(String campaignID) {
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(AccountsReceivableDunningCampaign.class);
        if (responsibleModuleService != null) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("campaignID", campaignID);
            return this.getDunningCampaignDTO((AccountsReceivableDunningCampaign)responsibleModuleService.getExternalizableBusinessObject(AccountsReceivableDunningCampaign.class, values));
        }
        return null;
    }

    @Override
    public List<DunningCampaignDTO> getMatching(@WebParam(name="searchCriteria") List<HashMapElement> searchCriteria) {
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(AccountsReceivableDunningCampaign.class);
        if (responsibleModuleService != null) {
            HashMap<String, String> values = new HashMap<String, String>();
            for (HashMapElement element : searchCriteria) {
                values.put(element.getKey(), element.getValue());
            }
            return this.getDunningCampaignDTO(responsibleModuleService.getExternalizableBusinessObjectsListForLookup(AccountsReceivableDunningCampaign.class, values, false));
        }
        return new ArrayList<DunningCampaignDTO>();
    }

    protected DunningCampaignDTO getDunningCampaignDTO(AccountsReceivableDunningCampaign dunningCampaign) {
        if (dunningCampaign != null) {
            DunningCampaignDTO dto = new DunningCampaignDTO();
            dto.setCampaignID(dunningCampaign.getCampaignID());
            dto.setCampaignDescription(dunningCampaign.getCampaignDescription());
            dto.setActive(dunningCampaign.isActive());
            return dto;
        }
        return null;
    }

    protected List<DunningCampaignDTO> getDunningCampaignDTO(List<AccountsReceivableDunningCampaign> campaigns) {
        if (campaigns != null) {
            ArrayList<DunningCampaignDTO> results = new ArrayList<DunningCampaignDTO>();
            for (AccountsReceivableDunningCampaign campaign : campaigns) {
                results.add(this.getDunningCampaignDTO(campaign));
            }
            return results;
        }
        return new ArrayList<DunningCampaignDTO>();
    }
}

