/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFund;
import org.kuali.kfs.module.external.kc.dto.AwardMethodOfPaymentDTO;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.AwardPaymentWebSoapService;
import org.kuali.kra.external.awardpayment.AwardPaymentWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class LetterOfCreditFundServiceImpl
implements ExternalizableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(LetterOfCreditFundServiceImpl.class);
    protected ConfigurationService configurationService;

    protected AwardPaymentWebService getWebService() {
        AwardPaymentWebService awardPaymentWebService = (AwardPaymentWebService)GlobalResourceLoader.getService((QName)KcConstants.AwardPayment.SERVICE);
        if (awardPaymentWebService == null) {
            LOG.warn((Object)"Couldn't get AwardWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            AwardPaymentWebSoapService ss = null;
            try {
                ss = new AwardPaymentWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize AwardPaymentWebSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize AwardPaymentWebSoapService: " + ex.getMessage());
            }
            awardPaymentWebService = ss.getAwardPaymentWebServicePort();
        }
        return awardPaymentWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        AwardMethodOfPaymentDTO dto = this.getWebService().getMethodOfPayment((String)primaryKeys.get("letterOfCreditFundCode"));
        return this.fundFromDTO(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        AwardMethodOfPaymentDTO criteria = new AwardMethodOfPaymentDTO();
        List<AwardMethodOfPaymentDTO> result = null;
        try {
            if (fieldValues.containsKey("letterOfCreditFundGroupCode") && StringUtils.length((String)((String)fieldValues.get("letterOfCreditFundGroupCode"))) > 0) {
                result = this.getWebService().getMatchingMethodOfPaymentsForBasisOfPayment((String)fieldValues.get("letterOfCreditFundGroupCode"));
            } else {
                criteria.setMethodOfPaymentCode((String)fieldValues.get("letterOfCreditFundCode"));
                criteria.setDescription((String)fieldValues.get("letterOfCreditFundDescription"));
                result = this.getWebService().getMatchingMethodOfPayments(criteria);
            }
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        ArrayList<LetterOfCreditFund> methods = new ArrayList<LetterOfCreditFund>();
        if (result != null) {
            for (AwardMethodOfPaymentDTO dto : result) {
                methods.add(this.fundFromDTO(dto));
            }
        }
        return methods;
    }

    protected LetterOfCreditFund fundFromDTO(AwardMethodOfPaymentDTO method) {
        LetterOfCreditFund fund = new LetterOfCreditFund();
        fund.setLetterOfCreditFundCode(method.getMethodOfPaymentCode());
        fund.setLetterOfCreditFundDescription(method.getDescription());
        return fund;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

