/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.HashMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.external.kc.service.impl.SponsorServiceImpl;
import org.kuali.kra.external.sponsor.SponsorCriteriaDto;
import org.kuali.kra.external.sponsor.SponsorWebService;

public class SponsorServiceImplTest {
    private SponsorServiceImpl sponsorService;
    private SponsorWebService sponsorWebService;

    @Before
    public void setup() {
        this.sponsorService = new SponsorServiceImpl();
        this.sponsorWebService = (SponsorWebService)EasyMock.createMock(SponsorWebService.class);
    }

    @Test
    public void testCriteriaMapping() {
        SponsorCriteriaDto criteria = new SponsorCriteriaDto();
        criteria.setSponsorCode("123");
        criteria.setCustomerNumber("234");
        criteria.setSponsorName("Sponsor");
        criteria.setDunsPlusFourNumber("0000");
        criteria.setActive("Y");
        EasyMock.expect((Object)this.sponsorWebService.getMatchingSponsors(SponsorServiceImplTest.eqCriteria(criteria))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.sponsorWebService});
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("agencyNumber", "123");
        fieldValues.put("customerNumber", "234");
        fieldValues.put("reportingName", "Sponsor");
        fieldValues.put("dunsPlusFourNumber", "0000");
        fieldValues.put("active", "Y");
        this.sponsorService.setWebService(this.sponsorWebService);
        this.sponsorService.findMatching(fieldValues);
        EasyMock.verify((Object[])new Object[]{this.sponsorWebService});
    }

    public static SponsorCriteriaDto eqCriteria(SponsorCriteriaDto in) {
        EasyMock.reportMatcher((IArgumentMatcher)new CriteriaEquals(in));
        return null;
    }

    private static class CriteriaEquals
    implements IArgumentMatcher {
        private SponsorCriteriaDto expected;

        public CriteriaEquals(SponsorCriteriaDto expected) {
            this.expected = expected;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append(ToStringBuilder.reflectionToString((Object)this.expected));
        }

        public boolean matches(Object actual) {
            return EqualsBuilder.reflectionEquals((Object)this.expected, (Object)actual);
        }
    }
}

