/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.external.kc.webService.KfsKcSoapService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class WebServicesImplTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(WebServicesImplTest.class);
    static final String TEST_BASE_PACKAGE = "org.kuali.kfs.module.external";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public boolean isValidfetchXML(URL location) throws SAXException, IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(location.openStream());
            doc.getDocumentElement().normalize();
            LOG.debug((Object)("Root Element " + doc.getDocumentElement().getNodeName()));
            return true;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void testWebServices() throws Exception {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(KfsKcSoapService.class));
        Set components = provider.findCandidateComponents(TEST_BASE_PACKAGE);
        for (BeanDefinition component : components) {
            String className = component.getBeanClassName();
            Class<?> kfsServiceClass = Class.forName(className);
            try {
                KfsKcSoapService kfsServiceInst = (KfsKcSoapService)kfsServiceClass.newInstance();
                URL myWsdl = kfsServiceInst.getWsdl();
                WebServicesImplTest.assertTrue((boolean)this.isValidfetchXML(myWsdl));
            }
            catch (Exception ex) {
                WebServicesImplTest.fail((String)ex.getMessage());
            }
        }
    }
}

