/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2017 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.external.kc.webService;

import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kra.external.frequency.FrequencyWebService;

import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * This class was generated by Apache CXF 2.2.10
 * Thu Sep 30 15:50:58 HST 2010
 * Generated source version: 2.2.10
 */


@WebServiceClient(name = KcConstants.Frequency.SOAP_SERVICE_NAME,
    wsdlLocation = "http://test.kc.kuali.org/kc-trunk/remoting/frequencyWebSoapService?wsdl",
    targetNamespace = KcConstants.KC_NAMESPACE_URI)
public class FrequencyWebSoapService extends KfsKcSoapService {

    public final static QName FrequencyWebServicePort = new QName(KcConstants.KC_NAMESPACE_URI, KcConstants.Frequency.SERVICE_PORT);

    static {
        try {
            getWsdl(KcConstants.Frequency.SERVICE);
        } catch (MalformedURLException e) {
            LOG.warn("Can not initialize the wsdl");
        }
    }

    public FrequencyWebSoapService() throws MalformedURLException {
        super(getWsdl(KcConstants.Frequency.SERVICE), KcConstants.Frequency.SERVICE);
    }


    /**
     * @return returns InstitutionalUnitService
     */
    @WebEndpoint(name = KcConstants.Frequency.SERVICE_PORT)
    public FrequencyWebService getFrequencyWebServicePort() {
        return super.getPort(FrequencyWebServicePort, FrequencyWebService.class);
    }

    /**
     * @param features A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return returns InstitutionalUnitService
     */
    @WebEndpoint(name = KcConstants.Frequency.SERVICE_PORT)
    public FrequencyWebService getFrequencyWebServicePort(WebServiceFeature... features) {
        return super.getPort(FrequencyWebServicePort, FrequencyWebService.class, features);
    }

    @Override
    public URL getWsdl() throws MalformedURLException {
        return super.getWsdl(KcConstants.Frequency.SERVICE);
    }

}
