/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.easymock.EasyMock;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.ar.businessobject.BillingFrequency;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.external.kc.dto.BillingFrequencyDTO;
import org.kuali.kfs.module.external.kc.service.impl.BillingFrequencyServiceImpl;

public class BillingFrequencyServiceImplTest {
    private BillingFrequencyServiceImpl billingFrequencyService;
    private ModuleService responsibleModuleService;

    @Before
    public void setup() {
        this.billingFrequencyService = new BillingFrequencyServiceImpl();
        this.responsibleModuleService = (ModuleService)EasyMock.createMock(ModuleService.class);
    }

    @Test
    public void testGetAll() {
        HashMap criteria = new HashMap();
        EasyMock.expect((Object)this.responsibleModuleService.getExternalizableBusinessObjectsListForLookup(AccountsReceivableBillingFrequency.class, criteria, true)).andReturn(this.getSampleBillingFrequencyList());
        EasyMock.replay((Object[])new Object[]{this.responsibleModuleService});
        this.billingFrequencyService.setResponsibleModuleService(this.responsibleModuleService);
        List results = this.billingFrequencyService.getAll();
        EasyMock.verify((Object[])new Object[]{this.responsibleModuleService});
        if (results.size() != 1) {
            Assert.fail((String)("billingFrequencyService.getAll() should have returned 1 result; instead it returned " + results.size()));
            return;
        }
        BillingFrequencyDTO result = (BillingFrequencyDTO)results.get(0);
        BillingFrequency expected = this.createSampleBillingFrequency();
        Assert.isTrue((boolean)this.compareBillingFrequencies(result, expected), (String)("Expected result was " + ToStringBuilder.reflectionToString((Object)expected) + " but got " + ToStringBuilder.reflectionToString((Object)result)));
    }

    @Test
    public void testGetActive() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("active", "Y");
        EasyMock.expect((Object)this.responsibleModuleService.getExternalizableBusinessObjectsListForLookup(AccountsReceivableBillingFrequency.class, criteria, true)).andReturn(this.getSampleBillingFrequencyList());
        EasyMock.replay((Object[])new Object[]{this.responsibleModuleService});
        this.billingFrequencyService.setResponsibleModuleService(this.responsibleModuleService);
        List results = this.billingFrequencyService.getActive();
        EasyMock.verify((Object[])new Object[]{this.responsibleModuleService});
        if (results.size() != 1) {
            Assert.fail((String)("billingFrequencyService.getActive() should have returned 1 result; instead it returned " + results.size()));
            return;
        }
        BillingFrequencyDTO result = (BillingFrequencyDTO)results.get(0);
        BillingFrequency expected = this.createSampleBillingFrequency();
        Assert.isTrue((boolean)this.compareBillingFrequencies(result, expected), (String)("Expected result was " + ToStringBuilder.reflectionToString((Object)expected) + " but got " + ToStringBuilder.reflectionToString((Object)result)));
    }

    @Test
    public void testGetBillingFrequency() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("frequency", "Sample");
        EasyMock.expect((Object)this.responsibleModuleService.getExternalizableBusinessObject(AccountsReceivableBillingFrequency.class, criteria)).andReturn((Object)this.createSampleBillingFrequency());
        EasyMock.replay((Object[])new Object[]{this.responsibleModuleService});
        this.billingFrequencyService.setResponsibleModuleService(this.responsibleModuleService);
        BillingFrequencyDTO result = this.billingFrequencyService.getBillingFrequency("Sample");
        BillingFrequency expected = this.createSampleBillingFrequency();
        Assert.isTrue((boolean)this.compareBillingFrequencies(result, expected), (String)("Expected result was " + ToStringBuilder.reflectionToString((Object)expected) + " but got " + ToStringBuilder.reflectionToString((Object)result)));
    }

    private List<AccountsReceivableBillingFrequency> getSampleBillingFrequencyList() {
        ArrayList<AccountsReceivableBillingFrequency> results = new ArrayList<AccountsReceivableBillingFrequency>();
        BillingFrequency billingFrequency = this.createSampleBillingFrequency();
        results.add((AccountsReceivableBillingFrequency)billingFrequency);
        return results;
    }

    private BillingFrequency createSampleBillingFrequency() {
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setActive(true);
        billingFrequency.setFrequency("Sample");
        billingFrequency.setFrequencyDescription("Sample Billing Frequency");
        billingFrequency.setGracePeriodDays(Integer.valueOf(3));
        return billingFrequency;
    }

    private boolean compareBillingFrequencies(BillingFrequencyDTO result, BillingFrequency expected) {
        return expected.isActive() == result.isActive() && expected.getFrequency().equals(result.getFrequency()) && expected.getFrequencyDescription().equals(result.getFrequencyDescription()) && expected.getGracePeriodDays().equals(result.getGracePeriodDays());
    }
}

