/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.integration.cg.dto.AccountCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.AccountParametersDTO;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.module.external.kc.service.AccountCreationService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class AccountCreationServiceImplTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(AccountCreationServiceImplTest.class);
    private AccountCreationService accountCreationService;
    private DateTimeService dateTimeService;

    protected void setUp() throws Exception {
        super.setUp();
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.accountCreationService = (AccountCreationService)SpringContext.getBean(AccountCreationService.class);
        this.changeCurrentUser(UserNameFixture.khuntley);
    }

    protected void changeCurrentUser(UserNameFixture sessionUser) throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession(sessionUser.toString()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDummyTest() {
    }

    public AccountParametersDTO getAccountParameters() {
        AccountParametersDTO accountParameters = new AccountParametersDTO();
        accountParameters.setPrincipalId(GlobalVariables.getUserSession().getPrincipalId());
        accountParameters.setAccountName("Test Account Name");
        accountParameters.setAccountNumber("1031400");
        accountParameters.setCfdaNumber("123456");
        accountParameters.setExpenseGuidelineText("expense guidelines");
        accountParameters.setIncomeGuidelineText("income guidelines");
        accountParameters.setPurposeText("purpose text");
        accountParameters.setOffCampusIndicator(true);
        accountParameters.setEffectiveDate(this.dateTimeService.getCurrentDate());
        accountParameters.setExpirationDate(this.dateTimeService.getCurrentDate());
        accountParameters.setUnit("000001");
        return accountParameters;
    }

    public AccountAutoCreateDefaults getAccountAutoCreateDefaults() {
        AccountAutoCreateDefaults defaults = new AccountAutoCreateDefaults();
        defaults.setKcUnit("testUnit");
        return defaults;
    }

    public void norun_testCreateRouteAutomaticCGAccountDocument() throws WorkflowException {
        AccountParametersDTO accountParametersDTO = this.getAccountParameters();
        TestUtils.setSystemParameter(Account.class, (String)"RESEARCH_ADMIN_AUTO_CREATE_ACCOUNT_WORKFLOW_ACTION", (String)"Save");
        AccountCreationStatusDTO accountCreationStatusDTO = this.accountCreationService.createAccount(accountParametersDTO);
        AccountCreationServiceImplTest.assertTrue((boolean)ObjectUtils.isNotNull((Object)accountCreationStatusDTO.getErrorMessages()));
        String documentNumber = accountCreationStatusDTO.getDocumentNumber();
        AccountCreationServiceImplTest.assertTrue((boolean)StringUtils.isNotEmpty((String)documentNumber));
        MaintenanceDocument retrievedDoc = (MaintenanceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(documentNumber);
        AccountCreationServiceImplTest.assertTrue((String)"Document shouldn't be null", (boolean)ObjectUtils.isNotNull((Object)retrievedDoc));
        AccountCreationServiceImplTest.assertEquals((String)"Document is in incorrect workflow status; should be SAVED", (Object)DocumentStatus.SAVED, (Object)retrievedDoc.getDocumentHeader().getWorkflowDocument().getStatus());
    }
}

