/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.module.external.kc.businessobject.Award;
import org.kuali.kfs.module.external.kc.businessobject.AwardAccount;

public class AwardTest {
    private AwardAccount awardAccount1 = this.createAwardAccount("Test-00001");
    private AwardAccount awardAccount2 = this.createAwardAccount("Test-00002");
    private AwardAccount awardAccount3 = this.createAwardAccount("Test-00003");

    @Test
    public void testGetActiveAccountsByAccount() {
        Award award = this.createAward("Test-00002", "2");
        List activeAwardAccounts = award.getActiveAwardAccounts();
        List<AwardAccount> expectedResults = Arrays.asList(this.awardAccount2);
        Assert.assertTrue((String)("Expected " + this.toString(expectedResults) + "; got " + this.toString(activeAwardAccounts)), (boolean)activeAwardAccounts.equals(expectedResults));
    }

    @Test
    public void testGetActiveAccountsByAwardHierarchy1() {
        Award award = this.createAward("Test-00001", "1");
        List activeAwardAccounts = award.getActiveAwardAccounts();
        List<AwardAccount> expectedResults = Arrays.asList(this.awardAccount1, this.awardAccount2, this.awardAccount3);
        Assert.assertTrue((String)("Expected " + this.toString(expectedResults) + "; got " + this.toString(activeAwardAccounts)), (boolean)activeAwardAccounts.equals(expectedResults));
    }

    @Test
    public void testGetActiveAccountsByAwardHierarchy2() {
        Award award = this.createAward("Test-00002", "1");
        List activeAwardAccounts = award.getActiveAwardAccounts();
        Assert.assertTrue((String)("No award accounts should have been returned, instead got " + this.toString(activeAwardAccounts)), (boolean)activeAwardAccounts.isEmpty());
    }

    @Test
    public void testGetActiveAccountsByCCA1() {
        Award award = this.createAward("Test-00001", "3");
        List activeAwardAccounts = award.getActiveAwardAccounts();
        List<AwardAccount> expectedResults = Arrays.asList(this.awardAccount1, this.awardAccount2, this.awardAccount3);
        Assert.assertTrue((String)("Expected " + this.toString(expectedResults) + "; got " + this.toString(activeAwardAccounts)), (boolean)activeAwardAccounts.equals(expectedResults));
    }

    @Test
    public void testGetActiveAccountsByCCA2() {
        Award award = this.createAward("Test-00002", "3");
        List activeAwardAccounts = award.getActiveAwardAccounts();
        Assert.assertTrue((String)("No award accounts should have been returned, instead got " + this.toString(activeAwardAccounts)), (boolean)activeAwardAccounts.isEmpty());
    }

    private Award createAward(String awardNumber, String invoicingOptionCode) {
        Award award = new Award();
        award.setAwardNumber(awardNumber);
        award.setInvoicingOptionCode(invoicingOptionCode);
        award.getAwardAccounts().add(this.awardAccount1);
        award.getAwardAccounts().add(this.awardAccount2);
        award.getAwardAccounts().add(this.awardAccount3);
        return award;
    }

    private AwardAccount createAwardAccount(String awardNumber) {
        AwardAccount awardAccount = new AwardAccount();
        Award award = new Award();
        award.setAwardNumber(awardNumber);
        awardAccount.setAward(award);
        return awardAccount;
    }

    private String toString(List<? extends ContractsAndGrantsBillingAwardAccount> awardAccounts) {
        return awardAccounts.stream().map(a -> ((AwardAccount)a).getAward().getAwardNumber()).collect(Collectors.joining(","));
    }
}

