/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.fp.businessobject.FiscalYearFunctionControl;
import org.kuali.kfs.fp.document.BudgetAdjustmentDocument;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.integration.cg.dto.BudgetAdjustmentCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.BudgetAdjustmentParametersDTO;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.external.kc.fixture.BudgetAdjustmentParameterDTOFixture;
import org.kuali.kfs.module.external.kc.fixture.BudgetAdjustmentParameterDTOLineFixture;
import org.kuali.kfs.module.external.kc.service.BudgetAdjustmentService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class BudgetAdjustmentServiceImplTest
extends KualiTestBase {
    private BudgetAdjustmentService budgetAdjustmentService;
    private Integer fiscalYear;

    protected void setUp() throws Exception {
        super.setUp();
        this.budgetAdjustmentService = (BudgetAdjustmentService)SpringContext.getBean(BudgetAdjustmentService.class);
        FiscalYearFunctionControlService fiscalYearFunctionControlService = (FiscalYearFunctionControlService)SpringContext.getBean(FiscalYearFunctionControlService.class);
        System.out.println("BA Allowed Years: " + fiscalYearFunctionControlService.getBudgetAdjustmentAllowedYears());
        this.fiscalYear = TestUtils.getFiscalYearForTesting();
        System.out.println("Testing FY: " + this.fiscalYear);
        FiscalYearFunctionControl fyfc = new FiscalYearFunctionControl();
        fyfc.setUniversityFiscalYear(this.fiscalYear);
        fyfc.setFinancialSystemFunctionControlCode("BAACTV");
        FiscalYearFunctionControl existingFyfc = (FiscalYearFunctionControl)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).retrieve((PersistableBusinessObject)fyfc);
        if (existingFyfc != null) {
            fyfc = existingFyfc;
            fyfc.setFinancialSystemFunctionActiveIndicator(true);
        }
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)fyfc);
        System.out.println("BA Allowed Years (after update): " + fiscalYearFunctionControlService.getBudgetAdjustmentAllowedYears());
    }

    public List<BudgetAdjustmentParametersDTO> getBudgetAdjustmentParameters() {
        ArrayList<BudgetAdjustmentParametersDTO> list = new ArrayList<BudgetAdjustmentParametersDTO>();
        TestUtils.setSystemParameter(BudgetAdjustmentDocument.class, (String)"RESEARCH_ADMIN_INCOME_OBJECT_CODE_BY_SPONSOR_TYPE", (String)BudgetAdjustmentParameterDTOFixture.CONTROL_3.getSystemParameterResearchSponsorType());
        BudgetAdjustmentParametersDTO budgetAdjustmentParametersDTO = BudgetAdjustmentParameterDTOFixture.CONTROL_3.createBudgetAdjustmentParameters();
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE1.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE2.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE3.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE4.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE5.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE6.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE7.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE8.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE9.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE10.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE11.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE12.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE13.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE14.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE15.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE16.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE17.createBudgetAdjustmentParameterDTO());
        budgetAdjustmentParametersDTO.getDetails().add(BudgetAdjustmentParameterDTOLineFixture.DETAIL_LINE18.createBudgetAdjustmentParameterDTO());
        list.add(budgetAdjustmentParametersDTO);
        return list;
    }

    public void testBudgetAdjustmentServiceSave() {
        List<BudgetAdjustmentParametersDTO> budgetAdjustmentParametersDTOs = this.getBudgetAdjustmentParameters();
        TestUtils.setSystemParameter(BudgetAdjustmentDocument.class, (String)"RESEARCH_ADMIN_BA_DOCUMENT_ROUTE_ACTION", (String)"Save");
        for (BudgetAdjustmentParametersDTO budgetAdjustmentParametersDTO : budgetAdjustmentParametersDTOs) {
            BudgetAdjustmentCreationStatusDTO status = this.budgetAdjustmentService.createBudgetAdjustment(budgetAdjustmentParametersDTO);
            BudgetAdjustmentServiceImplTest.assertTrue((String)("Errors during service call - save only: " + status.getErrorMessages()), (boolean)status.getErrorMessages().isEmpty());
        }
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testBudgetAdjustmentServiceRoute() throws Exception {
        List<BudgetAdjustmentParametersDTO> budgetAdjustmentParametersDTOs = this.getBudgetAdjustmentParameters();
        TestUtils.setSystemParameter(BudgetAdjustmentDocument.class, (String)"RESEARCH_ADMIN_BA_DOCUMENT_ROUTE_ACTION", (String)"Submit");
        for (BudgetAdjustmentParametersDTO budgetAdjustmentParametersDTO : budgetAdjustmentParametersDTOs) {
            BudgetAdjustmentCreationStatusDTO status = this.budgetAdjustmentService.createBudgetAdjustment(budgetAdjustmentParametersDTO);
            BudgetAdjustmentServiceImplTest.assertTrue((String)("Errors during service call - route: " + status.getErrorMessages()), (boolean)status.getErrorMessages().isEmpty());
        }
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testBudgetAdjustmentServiceBlanket() {
        List<BudgetAdjustmentParametersDTO> budgetAdjustmentParametersDTOs = this.getBudgetAdjustmentParameters();
        TestUtils.setSystemParameter(BudgetAdjustmentDocument.class, (String)"RESEARCH_ADMIN_BA_DOCUMENT_ROUTE_ACTION", (String)"BlanketApprove");
        for (BudgetAdjustmentParametersDTO budgetAdjustmentParametersDTO : budgetAdjustmentParametersDTOs) {
            BudgetAdjustmentCreationStatusDTO status = this.budgetAdjustmentService.createBudgetAdjustment(budgetAdjustmentParametersDTO);
            BudgetAdjustmentServiceImplTest.assertTrue((String)("Errors during service  call -blanketroute: " + status.getErrorMessages()), (boolean)status.getErrorMessages().isEmpty());
        }
    }

    public void testBudgetAdjustmentServiceFail() {
        List<BudgetAdjustmentParametersDTO> budgetAdjustmentParametersDTOs = this.getBudgetAdjustmentParameters();
        TestUtils.setSystemParameter(BudgetAdjustmentDocument.class, (String)"RESEARCH_ADMIN_BA_DOCUMENT_ROUTE_ACTION", (String)"I");
        for (BudgetAdjustmentParametersDTO budgetAdjustmentParametersDTO : budgetAdjustmentParametersDTOs) {
            BudgetAdjustmentCreationStatusDTO status = this.budgetAdjustmentService.createBudgetAdjustment(budgetAdjustmentParametersDTO);
            BudgetAdjustmentServiceImplTest.assertFalse((String)"Service call should have failed.", (boolean)status.getErrorMessages().isEmpty());
        }
    }
}

