/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.AgencyAddress;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.kra.external.sponsor.RolodexDTO;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
public class AgencyAddressTest {
    private AgencyAddress cut;
    @Mock
    private LocationService locationSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        PowerMockito.when((Object)SpringContext.getBean(LocationService.class, (String)"locationService-fin")).thenReturn((Object)this.locationSvcMock);
        this.cut = new AgencyAddress();
    }

    @Test
    public void nullCountryCode() {
        Mockito.when((Object)this.locationSvcMock.getDefaultCountry()).thenReturn((Object)this.getDefaultCountry());
        this.cut.init(this.getAgency(), this.getRolodexDto());
        ((LocationService)Mockito.verify((Object)this.locationSvcMock)).getDefaultCountry();
        ((LocationService)Mockito.verify((Object)this.locationSvcMock, (VerificationMode)Mockito.never())).getCountryByAlternateCode(ArgumentMatchers.anyString());
    }

    @Test
    public void validCountryCode() {
        Mockito.when((Object)this.locationSvcMock.getDefaultCountry()).thenReturn((Object)this.getDefaultCountry());
        Mockito.when((Object)this.locationSvcMock.getCountryByAlternateCode("USA")).thenReturn((Object)this.getDefaultCountry());
        RolodexDTO rolodexDto = this.getRolodexDto();
        rolodexDto.setCountryCode("USA");
        this.cut.init(this.getAgency(), rolodexDto);
        Assert.assertEquals((String)"Country code should be US.", (Object)"US", (Object)this.cut.getAgencyCountryCode());
        ((LocationService)Mockito.verify((Object)this.locationSvcMock)).getDefaultCountry();
        ((LocationService)Mockito.verify((Object)this.locationSvcMock)).getCountryByAlternateCode("USA");
    }

    private Country getDefaultCountry() {
        Country country = new Country();
        country.setCode("US");
        country.setAlternateCode("USA");
        country.setName("United States");
        country.setActive(true);
        return country;
    }

    private RolodexDTO getRolodexDto() {
        RolodexDTO r = new RolodexDTO();
        r.setRolodexId(Integer.valueOf(1));
        return r;
    }

    private Agency getAgency() {
        return new Agency();
    }
}

