/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.external.kc.dto.BillingFrequencyDTO;
import org.kuali.kfs.module.external.kc.service.BillingFrequencyService;

public class BillingFrequencyServiceImpl
implements BillingFrequencyService {
    private ModuleService responsibleModuleService;

    @Override
    public List<BillingFrequencyDTO> getAll() {
        return this.find(new HashMap<String, Object>());
    }

    @Override
    public List<BillingFrequencyDTO> getActive() {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("active", "Y");
        return this.find(criteria);
    }

    @Override
    public BillingFrequencyDTO getBillingFrequency(String frequency) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("frequency", frequency);
        AccountsReceivableBillingFrequency billingFrequency = (AccountsReceivableBillingFrequency)this.getResponsibleModuleService().getExternalizableBusinessObject(AccountsReceivableBillingFrequency.class, criteria);
        return this.getBillingFrequencyDTO(billingFrequency);
    }

    private List<BillingFrequencyDTO> find(Map<String, Object> criteria) {
        if (this.getResponsibleModuleService() != null) {
            return this.getBillingFrequencyDTO(this.getResponsibleModuleService().getExternalizableBusinessObjectsListForLookup(AccountsReceivableBillingFrequency.class, criteria, true));
        }
        return new ArrayList<BillingFrequencyDTO>();
    }

    protected BillingFrequencyDTO getBillingFrequencyDTO(AccountsReceivableBillingFrequency billingFrequency) {
        if (billingFrequency != null) {
            BillingFrequencyDTO dto = new BillingFrequencyDTO();
            dto.setFrequency(billingFrequency.getFrequency());
            dto.setFrequencyDescription(billingFrequency.getFrequencyDescription());
            dto.setGracePeriodDays(billingFrequency.getGracePeriodDays());
            dto.setActive(billingFrequency.isActive());
            return dto;
        }
        return null;
    }

    protected List<BillingFrequencyDTO> getBillingFrequencyDTO(List<AccountsReceivableBillingFrequency> billingFrequencies) {
        if (billingFrequencies != null) {
            ArrayList<BillingFrequencyDTO> results = new ArrayList<BillingFrequencyDTO>();
            for (AccountsReceivableBillingFrequency billingFrequency : billingFrequencies) {
                results.add(this.getBillingFrequencyDTO(billingFrequency));
            }
            return results;
        }
        return new ArrayList<BillingFrequencyDTO>();
    }

    public synchronized ModuleService getResponsibleModuleService() {
        if (this.responsibleModuleService == null) {
            this.responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(AccountsReceivableBillingFrequency.class);
        }
        return this.responsibleModuleService;
    }

    public void setResponsibleModuleService(ModuleService responsibleModuleService) {
        this.responsibleModuleService = responsibleModuleService;
    }
}

