/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.fp.businessobject.BudgetAdjustmentAccountingLine;
import org.kuali.kfs.fp.businessobject.BudgetAdjustmentSourceAccountingLine;
import org.kuali.kfs.fp.businessobject.BudgetAdjustmentTargetAccountingLine;
import org.kuali.kfs.fp.document.BudgetAdjustmentDocument;
import org.kuali.kfs.integration.cg.dto.BudgetAdjustmentCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.BudgetAdjustmentParametersDTO;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.krad.rules.rule.event.BlanketApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.external.kc.service.AccountCreationService;
import org.kuali.kfs.module.external.kc.service.BudgetAdjustmentService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.util.KcUtils;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TargetAccountingLine;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class BudgetAdjustmentServiceImpl
implements BudgetAdjustmentService {
    private static final Logger LOG = LogManager.getLogger(BudgetAdjustmentServiceImpl.class);
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected DataDictionaryService dataDictionaryService;
    protected BusinessObjectService businessObjectService;
    protected AccountCreationService accountCreationService;
    protected ObjectCodeService objectCodeService;
    protected KualiRuleService kualiRuleService;
    protected PersonService personService;
    protected MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private DocumentDictionaryService documentDictionaryService;

    @Override
    public BudgetAdjustmentCreationStatusDTO createBudgetAdjustment(BudgetAdjustmentParametersDTO budgetAdjustmentParameters) {
        BudgetAdjustmentDocument budgetAdjustmentDoc;
        BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatus = new BudgetAdjustmentCreationStatusDTO();
        budgetAdjustmentCreationStatus.setErrorMessages(new ArrayList());
        budgetAdjustmentCreationStatus.setStatus("success");
        String principalId = budgetAdjustmentParameters.getPrincipalId();
        if (!this.isValidUser(principalId)) {
            budgetAdjustmentCreationStatus.getErrorMessages().add(KcUtils.getErrorMessage("error.kc.document.invalid.user", new String[]{principalId}));
            budgetAdjustmentCreationStatus.setStatus("failure");
            return budgetAdjustmentCreationStatus;
        }
        try {
            budgetAdjustmentDoc = this.createBudgetAdjustmentObject(budgetAdjustmentCreationStatus);
            if (!this.isValidParameters(budgetAdjustmentDoc.getPostingYear(), budgetAdjustmentCreationStatus, budgetAdjustmentParameters)) {
                return budgetAdjustmentCreationStatus;
            }
            if (!this.populateBudgetAdjustmentDocDetails(budgetAdjustmentParameters, budgetAdjustmentDoc, budgetAdjustmentCreationStatus)) {
                return budgetAdjustmentCreationStatus;
            }
            this.routeBudgetAdjustmentDocument(budgetAdjustmentDoc, budgetAdjustmentCreationStatus);
        }
        catch (Exception ex) {
            this.setFailStatus(budgetAdjustmentCreationStatus, "Unable to generate KFS BudgetAdjustment Doc from data parameters");
            return budgetAdjustmentCreationStatus;
        }
        if (budgetAdjustmentCreationStatus.getStatus().equals("success") && this.getDocumentService().documentExists(budgetAdjustmentDoc.getDocumentHeader().getDocumentNumber())) {
            budgetAdjustmentCreationStatus.setDocumentNumber(budgetAdjustmentDoc.getDocumentNumber());
        } else {
            try {
                try {
                    GlobalVariables.getMessageMap().clearErrorMessages();
                    this.getDocumentService().saveDocument((Document)budgetAdjustmentDoc);
                }
                catch (ValidationException ex) {
                    // empty catch block
                }
                budgetAdjustmentCreationStatus.setDocumentNumber(budgetAdjustmentDoc.getDocumentNumber());
            }
            catch (Exception ex) {
                LOG.error(KcUtils.getErrorMessage("error.kc.document.workflowException.document.not.saved", null) + ": " + ex.getMessage());
                budgetAdjustmentCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                budgetAdjustmentCreationStatus.setStatus("failure");
            }
        }
        return budgetAdjustmentCreationStatus;
    }

    protected boolean checkforEmptyField(BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatusDTO, String fieldName, String value, int lineNumber) {
        if (value == null || value.isEmpty()) {
            String message = GlobalVariablesExtractHelper.replaceTokens("{0} is a required field", fieldName);
            this.setFailStatus(budgetAdjustmentCreationStatusDTO, message);
            return false;
        }
        return true;
    }

    protected void setFailStatus(BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatusDTO, String message) {
        budgetAdjustmentCreationStatusDTO.getErrorMessages().add(message);
        budgetAdjustmentCreationStatusDTO.setStatus("failure");
    }

    protected boolean isValidParameters(Integer postingFiscalYear, BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatusDTO, BudgetAdjustmentParametersDTO budgetAdjustmentParameters) {
        boolean isValidAcct = true;
        boolean isValid = this.checkforEmptyField(budgetAdjustmentCreationStatusDTO, "Description", budgetAdjustmentParameters.getDescription(), 0);
        List details = budgetAdjustmentParameters.getDetails();
        int lineNumber = 0;
        for (BudgetAdjustmentParametersDTO.Details detail : details) {
            String message;
            String message2;
            isValid &= this.checkforEmptyField(budgetAdjustmentCreationStatusDTO, "Account", detail.getAccount(), ++lineNumber);
            isValid &= this.checkforEmptyField(budgetAdjustmentCreationStatusDTO, "Chart", detail.getChart(), lineNumber);
            isValid &= this.checkforEmptyField(budgetAdjustmentCreationStatusDTO, "Object Code", detail.getObjectCode(), lineNumber);
            isValid &= this.checkforEmptyField(budgetAdjustmentCreationStatusDTO, "Amount", detail.getCurrentAmount(), lineNumber);
            if (!KualiDecimal.isNumeric((String)detail.getCurrentAmount())) {
                isValid = false;
                message2 = GlobalVariablesExtractHelper.replaceTokens("The current amount on the accounting line with object code {0} cannot be {1}", detail.getObjectCode(), detail.getCurrentAmount());
                this.setFailStatus(budgetAdjustmentCreationStatusDTO, message2);
            } else {
                KualiDecimal amt = new KualiDecimal(detail.getCurrentAmount());
                if (amt.isZero()) {
                    isValid = false;
                    message = GlobalVariablesExtractHelper.replaceTokens("The current amount on the accounting line with object code {0} cannot be {1}", detail.getObjectCode(), detail.getCurrentAmount());
                    this.setFailStatus(budgetAdjustmentCreationStatusDTO, message);
                }
            }
            if (isValidAcct && !this.accountCreationService.isValidChartAccount(detail.getChart(), detail.getAccount())) {
                isValid = false;
                isValidAcct = false;
                message2 = GlobalVariablesExtractHelper.replaceTokens("The KFS account {0} {1} is invalid: ", detail.getChart(), detail.getAccount());
                this.setFailStatus(budgetAdjustmentCreationStatusDTO, message2);
                continue;
            }
            ObjectCode objCode = this.objectCodeService.getByPrimaryId(postingFiscalYear, detail.getChart(), detail.getObjectCode());
            if (objCode == null) {
                isValid = false;
                message = GlobalVariablesExtractHelper.replaceTokens("The object code {0} {1} is not in the financial system", detail.getChart(), detail.getObjectCode());
                this.setFailStatus(budgetAdjustmentCreationStatusDTO, message);
                continue;
            }
            if (objCode.isFinancialObjectActiveCode()) continue;
            isValid = false;
            message = GlobalVariablesExtractHelper.replaceTokens("The object code {0} {1} is inactive for the year {2}", detail.getChart(), detail.getObjectCode(), postingFiscalYear.toString());
            this.setFailStatus(budgetAdjustmentCreationStatusDTO, message);
        }
        return isValid;
    }

    protected BudgetAdjustmentDocument createBudgetAdjustmentObject(BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatus) {
        BudgetAdjustmentDocument budgetAdjustmentDocument = (BudgetAdjustmentDocument)this.createBADocument(budgetAdjustmentCreationStatus);
        budgetAdjustmentDocument.initiateDocument();
        return budgetAdjustmentDocument;
    }

    protected boolean populateBudgetAdjustmentDocDetails(BudgetAdjustmentParametersDTO parameters, BudgetAdjustmentDocument budgetAdjustmentDocument, BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatus) {
        boolean methodSuccessful = true;
        budgetAdjustmentDocument.getDocumentHeader().setDocumentDescription(parameters.getDescription());
        budgetAdjustmentDocument.getDocumentHeader().setExplanation(parameters.getExplanation());
        budgetAdjustmentDocument.getDocumentHeader().setOrganizationDocumentNumber(parameters.getOrgDocNumber());
        KualiDecimal runningtotal = KualiDecimal.ZERO;
        Integer fiscalYear = budgetAdjustmentDocument.getPostingYear();
        if (parameters.getDetails() != null) {
            boolean success;
            for (BudgetAdjustmentParametersDTO.Details detail : parameters.getDetails()) {
                if (!KualiDecimal.isNumeric((String)detail.getCurrentAmount())) continue;
                KualiDecimal amount = new KualiDecimal(detail.getCurrentAmount());
                runningtotal = (KualiDecimal)runningtotal.add((AbstractKualiDecimal)amount);
                if (amount.isPositive()) {
                    budgetAdjustmentDocument.addTargetAccountingLine((TargetAccountingLine)this.createBudgetAdjustmentTargetAccountingLine(detail, fiscalYear));
                    continue;
                }
                budgetAdjustmentDocument.addSourceAccountingLine((SourceAccountingLine)this.createBudgetAdjustmentSourceAccountingLine(detail, fiscalYear));
            }
            if (runningtotal.isNonZero() && !(success = this.generateIncomeAccountingLine(fiscalYear, parameters.getSponsorType(), budgetAdjustmentDocument, runningtotal))) {
                budgetAdjustmentCreationStatus.getErrorMessages().add("The KFS system parameter value is invalid : RESEARCH_ADMIN_INCOME_OBJECT_CODE_BY_SPONSOR_TYPE");
                budgetAdjustmentCreationStatus.setStatus("failure");
                methodSuccessful = false;
            }
        }
        return methodSuccessful;
    }

    protected void populateAccountingLine(BudgetAdjustmentAccountingLine acctLine, Integer postingYear, String chart, String accountNumber, String proj, String objCode, KualiDecimal currentBudgetAdjustmentAmount) {
        acctLine.setChartOfAccountsCode(chart);
        acctLine.setAccountNumber(accountNumber);
        if (proj != null && !proj.isEmpty()) {
            acctLine.setProjectCode(proj);
        }
        acctLine.setFinancialObjectCode(objCode);
        acctLine.setCurrentBudgetAdjustmentAmount(currentBudgetAdjustmentAmount);
        acctLine.setPostingYear(postingYear);
        acctLine.refresh();
    }

    protected BudgetAdjustmentSourceAccountingLine createBudgetAdjustmentSourceAccountingLine(BudgetAdjustmentParametersDTO.Details detail, Integer postingYear) {
        BudgetAdjustmentSourceAccountingLine budgetAdjustmentSourceAccountingLine = new BudgetAdjustmentSourceAccountingLine();
        KualiDecimal amount = (KualiDecimal)new KualiDecimal(detail.getCurrentAmount()).abs();
        this.populateAccountingLine((BudgetAdjustmentAccountingLine)budgetAdjustmentSourceAccountingLine, postingYear, detail.getChart(), detail.getAccount(), detail.getProjectCode(), detail.getObjectCode(), amount);
        return budgetAdjustmentSourceAccountingLine;
    }

    protected BudgetAdjustmentTargetAccountingLine createBudgetAdjustmentTargetAccountingLine(BudgetAdjustmentParametersDTO.Details detail, Integer postingYear) {
        BudgetAdjustmentTargetAccountingLine budgetAdjustmentTargetAccountingLine = new BudgetAdjustmentTargetAccountingLine();
        KualiDecimal amount = (KualiDecimal)new KualiDecimal(detail.getCurrentAmount()).abs();
        this.populateAccountingLine((BudgetAdjustmentAccountingLine)budgetAdjustmentTargetAccountingLine, postingYear, detail.getChart(), detail.getAccount(), detail.getProjectCode(), detail.getObjectCode(), amount);
        return budgetAdjustmentTargetAccountingLine;
    }

    protected boolean generateIncomeAccountingLine(Integer postingYear, String sponsorType, BudgetAdjustmentDocument baDoc, KualiDecimal amount) {
        String sponsorCodeMapValue = this.parameterService.getSubParameterValueAsString(BudgetAdjustmentDocument.class, "RESEARCH_ADMIN_INCOME_OBJECT_CODE_BY_SPONSOR_TYPE", sponsorType);
        if (StringUtils.isBlank((CharSequence)sponsorCodeMapValue)) {
            return false;
        }
        if (amount.isNegative()) {
            SourceAccountingLine accountingLineDetail = baDoc.getSourceAccountingLine(0);
            BudgetAdjustmentSourceAccountingLine budgetAdjustmentSourceAccountingLine = new BudgetAdjustmentSourceAccountingLine();
            this.populateAccountingLine((BudgetAdjustmentAccountingLine)budgetAdjustmentSourceAccountingLine, postingYear, accountingLineDetail.getChartOfAccountsCode(), accountingLineDetail.getAccountNumber(), accountingLineDetail.getProjectCode(), sponsorCodeMapValue, (KualiDecimal)amount.abs());
            baDoc.addSourceAccountingLine((SourceAccountingLine)budgetAdjustmentSourceAccountingLine);
        } else {
            TargetAccountingLine accountingLineDetail = baDoc.getTargetAccountingLine(0);
            BudgetAdjustmentTargetAccountingLine budgetAdjustmentTargetAccountingLine = new BudgetAdjustmentTargetAccountingLine();
            this.populateAccountingLine((BudgetAdjustmentAccountingLine)budgetAdjustmentTargetAccountingLine, postingYear, accountingLineDetail.getChartOfAccountsCode(), accountingLineDetail.getAccountNumber(), accountingLineDetail.getProjectCode(), sponsorCodeMapValue, (KualiDecimal)amount.abs());
            baDoc.addTargetAccountingLine((TargetAccountingLine)budgetAdjustmentTargetAccountingLine);
        }
        return true;
    }

    protected Document createBADocument(BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatusDTO) {
        try {
            Class documentClass = this.documentDictionaryService.getDocumentClassByName("BA");
            return this.getDocumentService().getNewDocument(documentClass);
        }
        catch (Exception e) {
            budgetAdjustmentCreationStatusDTO.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
            budgetAdjustmentCreationStatusDTO.setStatus("failure");
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean routeBudgetAdjustmentDocument(BudgetAdjustmentDocument budgetAdjustmentDocument, BudgetAdjustmentCreationStatusDTO budgetAdjustmentCreationStatus) {
        try {
            String BudgetAdjustAutoRouteValue = this.getParameterService().getParameterValueAsString(BudgetAdjustmentDocument.class, "RESEARCH_ADMIN_BA_DOCUMENT_ROUTE_ACTION");
            if (!("Save".equalsIgnoreCase(BudgetAdjustAutoRouteValue) || "submit".equalsIgnoreCase(BudgetAdjustAutoRouteValue) || "BlanketApprove".equalsIgnoreCase(BudgetAdjustAutoRouteValue))) {
                budgetAdjustmentCreationStatus.getErrorMessages().add("The system parameter value for RESEARCH_ADMIN_BA_DOCUMENT_ROUTE_ACTION should be either Save or Submit or BlanketApprove.");
                budgetAdjustmentCreationStatus.setStatus("failure");
                return false;
            }
            if (BudgetAdjustAutoRouteValue.equalsIgnoreCase("Save")) {
                boolean rulesPassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new SaveDocumentEvent((Document)budgetAdjustmentDocument));
                if (rulesPassed && GlobalVariables.getMessageMap().hasNoErrors()) {
                    this.getDocumentService().saveDocument((Document)budgetAdjustmentDocument);
                    return true;
                }
                budgetAdjustmentCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                try {
                    this.getDocumentService().saveDocument((Document)budgetAdjustmentDocument);
                }
                catch (ValidationException validationException) {
                    // empty catch block
                }
                budgetAdjustmentCreationStatus.setStatus("success");
                LOG.error(KcUtils.getErrorMessage("error.kc.document.ba.rules.exception", new String[]{budgetAdjustmentDocument.getDocumentNumber()}));
                return false;
            }
            if (BudgetAdjustAutoRouteValue.equalsIgnoreCase("BlanketApprove")) {
                boolean rulesPassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new BlanketApproveDocumentEvent((Document)budgetAdjustmentDocument));
                if (rulesPassed && GlobalVariables.getMessageMap().hasNoErrors()) {
                    this.getDocumentService().blanketApproveDocument((Document)budgetAdjustmentDocument, "", null);
                    return true;
                }
                budgetAdjustmentCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                try {
                    this.getDocumentService().saveDocument((Document)budgetAdjustmentDocument);
                }
                catch (ValidationException validationException) {
                    // empty catch block
                }
                budgetAdjustmentCreationStatus.setStatus("success");
                LOG.error(KcUtils.getErrorMessage("error.kc.document.ba.rules.exception", new String[]{budgetAdjustmentDocument.getDocumentNumber()}));
                return false;
            }
            if (!"submit".equalsIgnoreCase(BudgetAdjustAutoRouteValue)) return true;
            boolean rulesPassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new RouteDocumentEvent((Document)budgetAdjustmentDocument));
            if (rulesPassed && GlobalVariables.getMessageMap().hasNoErrors()) {
                this.getDocumentService().routeDocument((Document)budgetAdjustmentDocument, "", null);
                return true;
            }
            budgetAdjustmentCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
            try {
                this.getDocumentService().saveDocument((Document)budgetAdjustmentDocument);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            budgetAdjustmentCreationStatus.setStatus("success");
            LOG.error(KcUtils.getErrorMessage("error.kc.document.ba.rules.exception", new String[]{budgetAdjustmentDocument.getDocumentNumber()}));
            return false;
        }
        catch (Exception ex) {
            LOG.error(KcUtils.getErrorMessage("error.kc.document.workflowException.document.actions", null) + ": " + ex.getMessage());
            budgetAdjustmentCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
            budgetAdjustmentCreationStatus.getErrorMessages().add(KcUtils.getErrorMessage("error.kc.document.workflowException.document.actions", null) + ": " + ex.getMessage());
            budgetAdjustmentCreationStatus.setStatus("failure");
            return false;
        }
    }

    protected boolean isValidUser(String principalId) {
        try {
            Person user = this.personService.getPerson(principalId);
            MaintenanceDocumentAuthorizerBase documentAuthorizer = new MaintenanceDocumentAuthorizerBase();
            if (documentAuthorizer.canInitiate(this.maintenanceDocumentDictionaryService.getDocumentTypeName(Account.class), user)) {
                GlobalVariables.setUserSession((UserSession)new UserSession(user.getPrincipalName()));
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LOG.error(KcUtils.getErrorMessage("error.kc.document.invalid.user", new String[]{principalId}));
            return false;
        }
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public AccountCreationService getAccountCreationService() {
        return this.accountCreationService;
    }

    public void setAccountCreationService(AccountCreationService accountCreationService) {
        this.accountCreationService = accountCreationService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        return this.maintenanceDocumentDictionaryService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }
}

