/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.AgencyAddress;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.kra.external.sponsor.RolodexDTO;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

class AgencyAddressTest {
    @Mock
    private LocationService locationSvcMock;
    private AgencyAddress cutSpy;

    AgencyAddressTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cutSpy = (AgencyAddress)Mockito.spy((Object)new AgencyAddress());
        ((AgencyAddress)Mockito.doReturn((Object)this.locationSvcMock).when((Object)this.cutSpy)).getLocationService();
    }

    @Test
    void nullCountryCode() {
        Mockito.when((Object)this.locationSvcMock.getDefaultCountry()).thenReturn((Object)this.getDefaultCountry());
        this.cutSpy.init(this.getAgency(), this.getRolodexDto());
        ((LocationService)Mockito.verify((Object)this.locationSvcMock)).getDefaultCountry();
        ((LocationService)Mockito.verify((Object)this.locationSvcMock, (VerificationMode)Mockito.never())).getCountryByAlternateCode(ArgumentMatchers.anyString());
    }

    @Test
    void validCountryCode() {
        Mockito.when((Object)this.locationSvcMock.getDefaultCountry()).thenReturn((Object)this.getDefaultCountry());
        Mockito.when((Object)this.locationSvcMock.getCountryByAlternateCode("USA")).thenReturn((Object)this.getDefaultCountry());
        RolodexDTO rolodexDto = this.getRolodexDto();
        rolodexDto.setCountryCode("USA");
        this.cutSpy.init(this.getAgency(), rolodexDto);
        Assertions.assertEquals((Object)"US", (Object)this.cutSpy.getAgencyCountryCode(), (String)"Country code should be US.");
        ((LocationService)Mockito.verify((Object)this.locationSvcMock)).getDefaultCountry();
        ((LocationService)Mockito.verify((Object)this.locationSvcMock)).getCountryByAlternateCode("USA");
    }

    private Country getDefaultCountry() {
        Country country = new Country();
        country.setCode("US");
        country.setAlternateCode("USA");
        country.setName("United States");
        country.setActive(true);
        return country;
    }

    private RolodexDTO getRolodexDto() {
        RolodexDTO r = new RolodexDTO();
        r.setRolodexId(Integer.valueOf(1));
        return r;
    }

    private Agency getAgency() {
        return new Agency();
    }
}

