/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.ar.businessobject.BillingFrequency;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.external.kc.dto.BillingFrequencyDTO;
import org.kuali.kfs.module.external.kc.service.impl.BillingFrequencyServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class BillingFrequencyServiceImplTest {
    private BillingFrequencyServiceImpl cut;
    @Mock
    private ModuleService responsibleModuleSvcMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new BillingFrequencyServiceImpl();
    }

    @Test
    public void getAll() {
        HashMap criteria = new HashMap();
        Mockito.when((Object)this.responsibleModuleSvcMock.getExternalizableBusinessObjectsListForLookup(AccountsReceivableBillingFrequency.class, criteria, true)).thenReturn(this.getSampleBillingFrequencyList());
        this.cut.setResponsibleModuleService(this.responsibleModuleSvcMock);
        List results = this.cut.getAll();
        Assert.assertTrue((String)"results should have only contained 1 item", (results.size() == 1 ? 1 : 0) != 0);
        BillingFrequencyDTO result = (BillingFrequencyDTO)results.get(0);
        BillingFrequency expected = this.createSampleBillingFrequency();
        Assert.assertTrue((boolean)this.compareBillingFrequencies(result, expected));
    }

    @Test
    public void getActive() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("active", "Y");
        Mockito.when((Object)this.responsibleModuleSvcMock.getExternalizableBusinessObjectsListForLookup(AccountsReceivableBillingFrequency.class, criteria, true)).thenReturn(this.getSampleBillingFrequencyList());
        this.cut.setResponsibleModuleService(this.responsibleModuleSvcMock);
        List results = this.cut.getActive();
        Assert.assertTrue((String)"results should have only contained 1 item", (results.size() == 1 ? 1 : 0) != 0);
        BillingFrequencyDTO result = (BillingFrequencyDTO)results.get(0);
        BillingFrequency expected = this.createSampleBillingFrequency();
        Assert.assertTrue((boolean)this.compareBillingFrequencies(result, expected));
    }

    @Test
    public void getBillingFrequency() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("frequency", "Sample");
        Mockito.when((Object)((AccountsReceivableBillingFrequency)this.responsibleModuleSvcMock.getExternalizableBusinessObject(AccountsReceivableBillingFrequency.class, criteria))).thenReturn((Object)this.createSampleBillingFrequency());
        this.cut.setResponsibleModuleService(this.responsibleModuleSvcMock);
        BillingFrequencyDTO result = this.cut.getBillingFrequency("Sample");
        BillingFrequency expected = this.createSampleBillingFrequency();
        Assert.assertTrue((boolean)this.compareBillingFrequencies(result, expected));
    }

    private List<AccountsReceivableBillingFrequency> getSampleBillingFrequencyList() {
        ArrayList<AccountsReceivableBillingFrequency> results = new ArrayList<AccountsReceivableBillingFrequency>();
        BillingFrequency billingFrequency = this.createSampleBillingFrequency();
        results.add((AccountsReceivableBillingFrequency)billingFrequency);
        return results;
    }

    private BillingFrequency createSampleBillingFrequency() {
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setActive(true);
        billingFrequency.setFrequency("Sample");
        billingFrequency.setFrequencyDescription("Sample Billing Frequency");
        billingFrequency.setGracePeriodDays(Integer.valueOf(3));
        return billingFrequency;
    }

    private boolean compareBillingFrequencies(BillingFrequencyDTO result, BillingFrequency expected) {
        return expected.isActive() == result.isActive() && expected.getFrequency().equals(result.getFrequency()) && expected.getFrequencyDescription().equals(result.getFrequencyDescription()) && expected.getGracePeriodDays().equals(result.getGracePeriodDays());
    }
}

