/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import org.kuali.kfs.integration.cg.ContractsAndGrantsCfda;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import java.io.Serializable;

/**
 * <p>Java class for cfdaDTO complex type.
 * <p>
 * The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;complexType name="cfdaDTO">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="active" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *         &lt;element name="awardId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="cfdaMaintenanceTypeId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="cfdaNumber" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="cfdaProgramTitleName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(
    name = "cfdaDTO",
    propOrder = {
        "active",
        "awardId",
        "cfdaMaintenanceTypeId",
        "cfdaNumber",
        "cfdaProgramTitleName"
    })
public class CfdaDTO implements ContractsAndGrantsCfda, Serializable {

    protected boolean active;
    protected String awardId;
    protected String cfdaMaintenanceTypeId;
    protected String cfdaNumber;
    protected String cfdaProgramTitleName;

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public String getAwardId() {
        return awardId;
    }

    public void setAwardId(String value) {
        this.awardId = value;
    }

    public String getCfdaMaintenanceTypeId() {
        return cfdaMaintenanceTypeId;
    }

    public void setCfdaMaintenanceTypeId(String value) {
        this.cfdaMaintenanceTypeId = value;
    }

    public String getCfdaNumber() {
        return cfdaNumber;
    }

    public void setCfdaNumber(String value) {
        this.cfdaNumber = value;
    }

    public String getCfdaProgramTitleName() {
        return cfdaProgramTitleName;
    }

    public void setCfdaProgramTitleName(String value) {
        this.cfdaProgramTitleName = value;
    }

    @Override
    public void refresh() {
    }

}
