/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * This class defines an agency as it is used and referenced within the Contracts & Grants portion of a college or
 * university financial system.
 */
public class Agency implements ContractsAndGrantsBillingAgency, MutableInactivatable {

    private String agencyNumber;
    private String reportingName;
    private String fullName;
    private String agencyTypeCode;
    private String reportsToAgencyNumber;
    private KualiDecimal indirectAmount;
    private boolean inStateIndicator;
    private Agency reportsToAgency;
    private boolean active;
    private String customerNumber;
    private String customerTypeCode;
    private String dunsPlusFourNumber;
    private AccountsReceivableCustomer customer;
    private boolean stateAgencyIndicator;
    private List<AgencyAddress> agencyAddresses;

    public Agency() {
    }

    public Agency(SponsorDTO kcSponsor) {
        setAgencyNumber(kcSponsor.getSponsorCode());
        setReportingName(kcSponsor.getSponsorName());
        setFullName(kcSponsor.getSponsorName());
        setAgencyTypeCode(kcSponsor.getSponsorTypeCode());
        setActive(kcSponsor.isActive());
        setDunsPlusFourNumber(kcSponsor.getDunsPlusFourNumber());
        setStateAgencyIndicator(kcSponsor.isStateAgency());
        setCustomerTypeCode(kcSponsor.getCustomerTypeCode());
        setCustomerNumber(kcSponsor.getCustomerNumber());
        setActive(kcSponsor.isActive());
        agencyAddresses = new ArrayList<>();
        agencyAddresses.add(new AgencyAddress(this, kcSponsor.getContactInformation()));
    }

    public String getAgencyTypeCode() {
        return agencyTypeCode;
    }

    public void setAgencyTypeCode(String agencyTypeCode) {
        this.agencyTypeCode = agencyTypeCode;
    }

    public String getReportsToAgencyNumber() {
        return reportsToAgencyNumber;
    }

    public void setReportsToAgencyNumber(String reportsToAgencyNumber) {
        this.reportsToAgencyNumber = reportsToAgencyNumber;
    }

    @Override
    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    @Override
    public String getReportingName() {
        return reportingName;
    }

    public void setReportingName(String reportingName) {
        this.reportingName = reportingName;
    }

    @Override
    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public KualiDecimal getIndirectAmount() {
        return indirectAmount;
    }

    public void setIndirectAmount(KualiDecimal indirectAmount) {
        this.indirectAmount = indirectAmount;
    }

    public boolean isInStateIndicator() {
        return inStateIndicator;
    }

    public void setInStateIndicator(boolean inStateIndicator) {
        this.inStateIndicator = inStateIndicator;
    }

    public Agency getReportsToAgency() {
        return reportsToAgency;
    }

    /**
     * todo Why is this deprecated?
     * @deprecated
     */
    @Deprecated
    public void setReportsToAgency(Agency reportsToAgencyNumber) {
        this.reportsToAgency = reportsToAgencyNumber;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public void prepareForWorkflow() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    @Override
    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    @Override
    public String getDunsPlusFourNumber() {
        return dunsPlusFourNumber;
    }

    public void setDunsPlusFourNumber(String dunsPlusFourNumber) {
        this.dunsPlusFourNumber = dunsPlusFourNumber;
    }

    @Override
    public AccountsReceivableCustomer getCustomer() {
        return customer;
    }

    public void setCustomer(AccountsReceivableCustomer customer) {
        this.customer = customer;
    }

    @Override
    public boolean isStateAgencyIndicator() {
        return stateAgencyIndicator;
    }

    public void setStateAgencyIndicator(boolean stateAgencyIndicator) {
        this.stateAgencyIndicator = stateAgencyIndicator;
    }

    @Override
    public List<AgencyAddress> getAgencyAddresses() {
        return agencyAddresses;
    }

    public void setAgencyAddresses(List<AgencyAddress> agencyAddresses) {
        this.agencyAddresses = agencyAddresses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Agency)) {
            return false;
        }
        Agency agency = (Agency) o;

        return agencyNumber.equals(agency.getAgencyNumber());
    }

    @Override
    public int hashCode() {
        return Objects.hash(agencyNumber);
    }
}
