/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.external.kc.service.impl.SponsorServiceImpl;
import org.kuali.kra.external.sponsor.SponsorCriteriaDto;
import org.kuali.kra.external.sponsor.SponsorWebService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class SponsorServiceImplTest {
    private SponsorServiceImpl cut;
    @Mock
    private SponsorWebService sponsorWebSvcMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new SponsorServiceImpl();
    }

    @Test
    public void criteriaMapping() {
        SponsorCriteriaDto criteria = new SponsorCriteriaDto();
        criteria.setSponsorCode("123");
        criteria.setCustomerNumber("234");
        criteria.setSponsorName("Sponsor");
        criteria.setDunsPlusFourNumber("0000");
        criteria.setActive("Y");
        Mockito.when((Object)this.sponsorWebSvcMock.getMatchingSponsors((SponsorCriteriaDto)ArgumentMatchers.refEq((Object)criteria, (String[])new String[0]))).thenReturn(null);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("agencyNumber", "123");
        fieldValues.put("customerNumber", "234");
        fieldValues.put("reportingName", "Sponsor");
        fieldValues.put("dunsPlusFourNumber", "0000");
        fieldValues.put("active", "Y");
        this.cut.setWebService(this.sponsorWebSvcMock);
        this.cut.findMatching(fieldValues);
        ((SponsorWebService)Mockito.verify((Object)this.sponsorWebSvcMock)).getMatchingSponsors((SponsorCriteriaDto)ArgumentMatchers.refEq((Object)criteria, (String[])new String[0]));
    }
}

