/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.style;

import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.kfs.coreservice.impl.style.StyleBo;
import org.kuali.kfs.coreservice.impl.style.StyleExportDataSet;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;

public class StyleXmlExporter
implements XmlExporter {
    private static final Logger LOG = Logger.getLogger(StyleXmlExporter.class);
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.STYLE_NAMESPACE);

    public boolean supportPrettyPrint() {
        return false;
    }

    public Element export(ExportDataSet exportDataSet) {
        StyleExportDataSet dataSet = StyleExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getStyles().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "styles");
            rootElement.setAttribute("schemaLocation", "ns:workflow/Style resource:Style", XmlConstants.SCHEMA_NAMESPACE);
            for (StyleBo edocLite : dataSet.getStyles()) {
                this.exportStyle(rootElement, edocLite);
            }
            return rootElement;
        }
        return null;
    }

    private void exportStyle(Element parentEl, StyleBo style) {
        if (style == null) {
            LOG.error((Object)"Attempted to export style which was not found");
            return;
        }
        Element styleWrapperEl = this.renderer.renderElement(parentEl, "style");
        this.renderer.renderAttribute(styleWrapperEl, "name", style.getName());
        try {
            Element styleEl = XmlHelper.buildJDocument((Reader)new StringReader(style.getXmlContent())).getRootElement();
            styleWrapperEl.addContent(styleEl.detach());
        }
        catch (XmlException e) {
            throw new RuntimeException("Error building JDom document for style", e);
        }
    }
}

