/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.web.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.kfs.coreservice.api.namespace.Namespace;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class NamespaceValuesFinder
extends KeyValuesBase {
    @Override
    public List<KeyValue> getKeyValues() {
        List<Namespace> namespaces = CoreServiceApiServiceLocator.getNamespaceService().findAllNamespaces();
        namespaces = namespaces == null ? new ArrayList<Namespace>(0) : new ArrayList<Namespace>(namespaces);
        Collections.sort(namespaces, NamespaceComparator.INSTANCE);
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>(namespaces.size());
        labels.add((KeyValue)new ConcreteKeyValue("", ""));
        List namespaceLabels = namespaces.stream().filter(namespace -> StringUtils.equalsIgnoreCase((String)namespace.getApplicationId(), (String)"KFS") || StringUtils.equalsIgnoreCase((String)namespace.getApplicationId(), (String)"RICE") || StringUtils.equalsIgnoreCase((String)namespace.getCode(), (String)"KUALI")).map(namespace -> new ConcreteKeyValue(namespace.getCode(), namespace.getCode() + " - " + namespace.getName())).collect(Collectors.toList());
        labels.addAll(namespaceLabels);
        return labels;
    }

    private static class NamespaceComparator
    implements Comparator<Namespace> {
        public static final Comparator<Namespace> INSTANCE = new NamespaceComparator();

        private NamespaceComparator() {
        }

        @Override
        public int compare(Namespace o1, Namespace o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }
}

