/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary.validation.charlevel;

import org.kuali.kfs.krad.datadictionary.exporter.ExportMap;
import org.kuali.kfs.krad.datadictionary.validation.CharacterLevelValidationPattern;

public class AlphaValidationPattern
extends CharacterLevelValidationPattern {
    protected boolean allowWhitespace = false;

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setAllowWhitespace(boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    @Override
    protected String getRegexString() {
        StringBuffer regexString = new StringBuffer("[A-Za-z");
        if (this.allowWhitespace) {
            regexString.append("\\s");
        }
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public void extendExportMap(ExportMap exportMap) {
        exportMap.set("type", "alpha");
        if (this.allowWhitespace) {
            exportMap.set("allowWhitespace", "true");
        }
    }

    @Override
    protected String getValidationErrorMessageKeyOptions() {
        if (this.getAllowWhitespace()) {
            return ".allowWhitespace";
        }
        return "";
    }
}

