/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.kim.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.datadictionary.control.CheckboxControlDefinition;
import org.kuali.kfs.kns.datadictionary.control.HiddenControlDefinition;
import org.kuali.kfs.kns.datadictionary.control.MultiselectControlDefinition;
import org.kuali.kfs.kns.datadictionary.control.RadioControlDefinition;
import org.kuali.kfs.kns.datadictionary.control.SelectControlDefinition;
import org.kuali.kfs.kns.datadictionary.control.TextControlDefinition;
import org.kuali.kfs.kns.datadictionary.control.TextareaControlDefinition;
import org.kuali.kfs.kns.kim.type.KimAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.control.ControlDefinition;
import org.kuali.kfs.krad.datadictionary.exporter.ExportMap;
import org.kuali.kfs.krad.datadictionary.validation.ValidationPattern;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinderFactory;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableControlContract;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextExpand;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.kim.api.type.KimAttributeField;

@Deprecated
public final class DataDictionaryTypeServiceHelper {
    private DataDictionaryTypeServiceHelper() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getKimBasePath() {
        String kimBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kim.url");
        if (!kimBaseUrl.endsWith("/")) {
            kimBaseUrl = kimBaseUrl + "/";
        }
        return kimBaseUrl;
    }

    public static RemotableAbstractControl.Builder toRemotableAbstractControlBuilder(AttributeDefinition attr) {
        ControlDefinition control = attr.getControl();
        if (control.isCheckbox()) {
            return RemotableCheckbox.Builder.create();
        }
        if (control.isHidden()) {
            return RemotableHiddenInput.Builder.create();
        }
        if (control.isMultiselect()) {
            RemotableSelect.Builder b = RemotableSelect.Builder.create(DataDictionaryTypeServiceHelper.getValues(attr));
            b.setMultiple(true);
            b.setSize(control.getSize());
        } else {
            if (control.isRadio()) {
                return RemotableRadioButtonGroup.Builder.create(DataDictionaryTypeServiceHelper.getValues(attr));
            }
            if (control.isSelect()) {
                RemotableSelect.Builder b = RemotableSelect.Builder.create(DataDictionaryTypeServiceHelper.getValues(attr));
                b.setMultiple(false);
                b.setSize(control.getSize());
                return b;
            }
            if (control.isText() || control.isCurrency()) {
                RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                b.setSize(control.getSize());
                return b;
            }
            if (control.isTextarea()) {
                RemotableTextarea.Builder b = RemotableTextarea.Builder.create();
                b.setCols(control.getCols());
                b.setRows(control.getRows());
                return b;
            }
        }
        return null;
    }

    private static Map<String, String> getValues(AttributeDefinition attr) {
        ControlDefinition control = attr.getControl();
        try {
            Class<?> clazz = Class.forName(control.getValuesFinderClass());
            KeyValuesFinder finder = (KeyValuesFinder)clazz.newInstance();
            Map<String, String> values = finder.getKeyLabelMap();
            if (values != null && !values.isEmpty()) {
                return values;
            }
            if (attr.getOptionsFinder() != null) {
                return attr.getOptionsFinder().getKeyLabelMap();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return Collections.emptyMap();
    }

    public static List<KimAttributeDefinition> toKimAttributeDefinitions(List<KimAttributeField> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields was null");
        }
        ArrayList<KimAttributeDefinition> defns = new ArrayList<KimAttributeDefinition>();
        for (KimAttributeField field : fields) {
            defns.add(DataDictionaryTypeServiceHelper.toKimAttributeDefinition(field));
        }
        return Collections.unmodifiableList(defns);
    }

    public static KimAttributeDefinition toKimAttributeDefinition(KimAttributeField field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        KimAttributeDefinition ad = new KimAttributeDefinition();
        ad.setKimAttrDefnId(field.getId());
        ad.setUnique(field.isUnique());
        final RemotableAttributeField attr = field.getAttributeField();
        ad.setName(attr.getName());
        ad.setDataType(attr.getDataType());
        ad.setShortLabel(attr.getShortLabel());
        ad.setLabel(attr.getLongLabel());
        ad.setSummary(attr.getHelpSummary());
        ad.setConstraintText(attr.getConstraintText());
        ad.setDescription(attr.getHelpDescription());
        ad.setForceUppercase(attr.isForceUpperCase());
        ad.setMinLength(attr.getMinLength());
        ad.setMaxLength(attr.getMaxLength());
        ad.setExclusiveMin(attr.getMinValue() != null ? attr.getMinValue().toString() : null);
        ad.setInclusiveMax(attr.getMaxValue() != null ? attr.getMaxValue().toString() : null);
        if (StringUtils.isNotBlank((String)attr.getRegexConstraint())) {
            ValidationPattern pattern = new ValidationPattern(){

                @Override
                public Pattern getRegexPattern() {
                    return Pattern.compile(this.getRegexString());
                }

                @Override
                protected String getRegexString() {
                    return attr.getRegexConstraint();
                }

                @Override
                public ExportMap buildExportMap(String exportKey) {
                    ExportMap exportMap = new ExportMap(exportKey);
                    exportMap.set("type", "regex");
                    exportMap.set("pattern", this.getRegexString());
                    return exportMap;
                }

                @Override
                public String getValidationErrorMessageKey() {
                    return attr.getRegexContraintMsg();
                }
            };
            ad.setValidationPattern(pattern);
        }
        ad.setRequired(attr.isRequired());
        RemotableControlContract control = field.getAttributeField().getControl();
        if (control != null) {
            ControlDefinition d = DataDictionaryTypeServiceHelper.toControlDefinition(control, ad);
            for (RemotableAbstractWidget widget : field.getAttributeField().getWidgets()) {
                if (widget instanceof RemotableQuickFinder) {
                    ad.setLookupBoClass(((RemotableQuickFinder)widget).getDataObjectClass());
                    ad.setLookupInputPropertyConversions(((RemotableQuickFinder)widget).getLookupParameters());
                    ad.setLookupReturnPropertyConversions(((RemotableQuickFinder)widget).getFieldConversions());
                    continue;
                }
                if (widget instanceof RemotableDatepicker && d != null) {
                    d.setDatePicker(true);
                    continue;
                }
                if (!(widget instanceof RemotableTextExpand) || d == null) continue;
                d.setExpandedTextArea(true);
            }
            ad.setControl(d);
        }
        return ad;
    }

    private static ControlDefinition toControlDefinition(RemotableControlContract control, KimAttributeDefinition containingAttribute) {
        if (control instanceof RemotableCheckboxGroup) {
            containingAttribute.setOptionsFinder(KeyValuesFinderFactory.fromMap(((RemotableCheckboxGroup)control).getKeyLabels()));
            CheckboxControlDefinition checkbox = new CheckboxControlDefinition();
            return checkbox;
        }
        if (control instanceof RemotableCheckbox) {
            CheckboxControlDefinition checkbox = new CheckboxControlDefinition();
            return checkbox;
        }
        if (control instanceof RemotableHiddenInput) {
            HiddenControlDefinition hidden = new HiddenControlDefinition();
            return hidden;
        }
        if (control instanceof RemotableRadioButtonGroup) {
            containingAttribute.setOptionsFinder(KeyValuesFinderFactory.fromMap(((RemotableRadioButtonGroup)control).getKeyLabels()));
            RadioControlDefinition radio = new RadioControlDefinition();
            return radio;
        }
        if (control instanceof RemotableSelect) {
            containingAttribute.setOptionsFinder(KeyValuesFinderFactory.fromMap(((RemotableSelect)control).getKeyLabels()));
            if (((RemotableSelect)control).isMultiple()) {
                MultiselectControlDefinition multiSelect = new MultiselectControlDefinition();
                multiSelect.setSize(((RemotableSelect)control).getSize());
                return multiSelect;
            }
            SelectControlDefinition select = new SelectControlDefinition();
            select.setSize(((RemotableSelect)control).getSize());
            return select;
        }
        if (control instanceof RemotableTextarea) {
            TextareaControlDefinition textarea = new TextareaControlDefinition();
            textarea.setRows(((RemotableTextarea)control).getRows());
            textarea.setCols(((RemotableTextarea)control).getCols());
            return textarea;
        }
        if (control instanceof RemotableTextInput) {
            TextControlDefinition text = new TextControlDefinition();
            text.setSize(((RemotableTextInput)control).getSize());
            return text;
        }
        return null;
    }

    public static <T extends KimAttributeField> T findAttributeField(String attributeName, Collection<? extends T> fields) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("attributeName is blank");
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields is null");
        }
        for (KimAttributeField field : fields) {
            if (!attributeName.equals(field.getAttributeField().getName())) continue;
            return (T)field;
        }
        return null;
    }

    public static String createErrorString(KimAttributeField definition) {
        return definition.getAttributeField().getRegexContraintMsg();
    }

    public static String createErrorString(String errorKey, String ... params) {
        StringBuilder s = new StringBuilder(errorKey).append(':');
        if (params != null) {
            for (String p : params) {
                if (p == null) continue;
                s.append(p);
                s.append(';');
            }
        }
        return s.toString();
    }

    public static String getAttributeErrorLabel(KimAttributeField definition) {
        String longAttributeLabel = definition.getAttributeField().getLongLabel();
        String shortAttributeLabel = definition.getAttributeField().getShortLabel();
        return longAttributeLabel + " (" + shortAttributeLabel + ")";
    }
}

