/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.struts.form.pojo.PojoForm;
import org.kuali.kfs.kns.web.struts.form.pojo.PojoFormBase;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public abstract class KualiAction
extends DispatchAction {
    private static final Logger LOG = Logger.getLogger(KualiAction.class);
    private static KualiModuleService kualiModuleService = null;
    private static BusinessObjectAuthorizationService businessObjectAuthorizationService = null;
    private static EncryptionService encryptionService = null;
    private static Boolean OUTPUT_ENCRYPTION_WARNING = null;
    private static String applicationBaseUrl = null;
    private Set<String> methodToCallsToNotCheckAuthorization = new HashSet<String>();
    public static final String TEXT_AREA_FIELD_NAME = "textAreaFieldName";
    public static final String TEXT_AREA_FIELD_LABEL = "textAreaFieldLabel";
    public static final String TEXT_AREA_READ_ONLY = "textAreaReadOnly";
    public static final String TEXT_AREA_FIELD_ANCHOR = "textAreaFieldAnchor";
    public static final String TEXT_AREA_MAX_LENGTH = "textAreaMaxLength";
    public static final String FORM_ACTION = "htmlFormAction";
    public static final String METHOD_TO_CALL = "methodToCall";
    public static final String FORWARD_TEXT_AREA_UPDATE = "updateTextArea";
    public static final String POST_TEXT_AREA_TO_PARENT = "postTextAreaToParent";
    public static final String FORWARD_NEXT = "forwardNext";

    public KualiAction() {
        this.methodToCallsToNotCheckAuthorization.add("performLookup");
        this.methodToCallsToNotCheckAuthorization.add("performQuestion");
        this.methodToCallsToNotCheckAuthorization.add("performQuestionWithInput");
        this.methodToCallsToNotCheckAuthorization.add("performQuestionWithInputAgainBecauseOfErrors");
        this.methodToCallsToNotCheckAuthorization.add("performQuestionWithoutInput");
        this.methodToCallsToNotCheckAuthorization.add("performWorkgroupLookup");
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward returnForward = null;
        String methodToCall = this.findMethodToCall(form, request);
        if (this.isModuleLocked(form, methodToCall, request)) {
            return mapping.findForward("moduleLocked");
        }
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getMethodToCall())) {
            if (StringUtils.isNotBlank((String)this.getImageContext(request, "anchor"))) {
                ((KualiForm)form).setAnchor(this.getImageContext(request, "anchor"));
            } else if (StringUtils.isNotBlank((String)request.getParameter("anchor"))) {
                ((KualiForm)form).setAnchor(request.getParameter("anchor"));
            }
        }
        if (StringUtils.isNotBlank((String)methodToCall)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("methodToCall: '" + methodToCall + "'"));
            }
            if ((returnForward = this.dispatchMethod(mapping, form, request, response, methodToCall)) != null && returnForward.getRedirect() && returnForward.getName() != null && returnForward.getName().equals("InitiatedDocumentView")) {
                return returnForward;
            }
        } else {
            returnForward = this.defaultDispatch(mapping, form, request, response);
        }
        if (!this.methodToCallsToNotCheckAuthorization.contains(methodToCall)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("'" + methodToCall + "' not in set of excempt methods: " + this.methodToCallsToNotCheckAuthorization));
            }
            this.checkAuthorization(form, methodToCall);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("'" + methodToCall + "' is exempt from auth checks."));
        }
        if (KNSGlobalVariables.getKualiForm() == null) {
            KNSGlobalVariables.setKualiForm((KualiForm)form);
        }
        return returnForward;
    }

    protected ActionForward defaultDispatch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String methodToCall) throws Exception {
        GlobalVariables.getUserSession().addObject("METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY", methodToCall);
        return super.dispatchMethod(mapping, form, request, response, methodToCall);
    }

    protected String findMethodToCall(ActionForm form, HttpServletRequest request) throws Exception {
        String methodToCall = form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getMethodToCall()) ? ((KualiForm)form).getMethodToCall() : WebUtils.parseMethodToCall(form, request);
        return methodToCall;
    }

    public ActionForward toggleTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiForm kualiForm = (KualiForm)form;
        String tabToToggle = this.getTabToToggle(request);
        if (StringUtils.isNotBlank((String)tabToToggle)) {
            if (kualiForm.getTabState(tabToToggle).equals(KualiForm.TabState.OPEN.name())) {
                kualiForm.getTabStates().remove(tabToToggle);
                kualiForm.getTabStates().put(tabToToggle, KualiForm.TabState.CLOSE.name());
            } else {
                kualiForm.getTabStates().remove(tabToToggle);
                kualiForm.getTabStates().put(tabToToggle, KualiForm.TabState.OPEN.name());
            }
        }
        this.doProcessingAfterPost(kualiForm, request);
        return mapping.findForward("basic");
    }

    public ActionForward showAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.doTabOpenOrClose(mapping, form, request, response, true);
    }

    public ActionForward hideAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.doTabOpenOrClose(mapping, form, request, response, false);
    }

    private ActionForward doTabOpenOrClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean open) {
        KualiForm kualiForm = (KualiForm)form;
        Map<String, String> tabStates = kualiForm.getTabStates();
        HashMap<String, String> newTabStates = new HashMap<String, String>();
        for (String tabKey : tabStates.keySet()) {
            newTabStates.put(tabKey, open ? "OPEN" : "CLOSE");
        }
        kualiForm.setTabStates(newTabStates);
        this.doProcessingAfterPost(kualiForm, request);
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    protected int getLineToDelete(HttpServletRequest request) {
        return this.getSelectedLine(request);
    }

    protected int getLineToEdit(HttpServletRequest request) {
        return this.getSelectedLine(request);
    }

    protected int getSelectedLine(HttpServletRequest request) {
        int selectedLine = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String lineNumber = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
            if (StringUtils.isEmpty((String)lineNumber)) {
                return selectedLine;
            }
            selectedLine = Integer.parseInt(lineNumber);
        }
        return selectedLine;
    }

    protected String getTabToToggle(HttpServletRequest request) {
        String tabToToggle = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            tabToToggle = StringUtils.substringBetween((String)parameterName, (String)".tab", (String)".");
        }
        return tabToToggle;
    }

    protected String getHeaderTabNavigateTo(HttpServletRequest request) {
        String headerTabNavigateTo = "basic";
        String imageContext = this.getImageContext(request, "navigateTo.");
        if (StringUtils.isNotBlank((String)imageContext)) {
            headerTabNavigateTo = imageContext;
        }
        return headerTabNavigateTo;
    }

    protected String getHeaderTabDispatch(HttpServletRequest request) {
        String headerTabDispatch = null;
        String imageContext = this.getImageContext(request, "headerDispatch.");
        headerTabDispatch = StringUtils.isNotBlank((String)imageContext) ? imageContext : request.getParameter("methodToCallAttribute");
        return headerTabDispatch;
    }

    protected String getImageContext(HttpServletRequest request, String contextKey) {
        String imageContext = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isBlank((String)parameterName)) {
            parameterName = request.getParameter("methodToCallPath");
        }
        if (StringUtils.isNotBlank((String)parameterName)) {
            imageContext = StringUtils.substringBetween((String)parameterName, (String)contextKey, (String)".");
        }
        return imageContext;
    }

    protected String getReturnLocation(HttpServletRequest request, ActionMapping mapping) {
        String mappingPath = mapping.getPath();
        String basePath = KualiAction.getApplicationBaseUrl();
        return basePath + ("/lookup".equals(mappingPath) || "/maintenance".equals(mappingPath) || "/multipleValueLookup".equals(mappingPath) ? "/kr" : "") + mappingPath + ".do";
    }

    protected String retrieveLookupParameterValue(Class<? extends BusinessObject> boClass, String parameterName, String parameterValuePropertyName, ActionForm form, HttpServletRequest request) throws Exception {
        String value;
        if (StringUtils.contains((String)parameterValuePropertyName, (String)"'")) {
            value = StringUtils.replace((String)parameterValuePropertyName, (String)"'", (String)"");
        } else if (request.getParameterMap().containsKey(parameterValuePropertyName)) {
            value = request.getParameter(parameterValuePropertyName);
        } else if (request.getParameterMap().containsKey("documentAttribute." + parameterValuePropertyName)) {
            value = request.getParameter("documentAttribute." + parameterValuePropertyName);
        } else if (form instanceof KualiForm) {
            value = ((KualiForm)form).retrieveFormValueForLookupInquiryParameters(parameterName, parameterValuePropertyName);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to retrieve lookup/inquiry parameter value for parameter name " + parameterName + " parameter value property " + parameterValuePropertyName));
            }
            value = null;
        }
        if (value != null && boClass != null && this.getBusinessObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(boClass, parameterName) && CoreApiServiceLocator.getEncryptionService().isEnabled()) {
            value = this.getEncryptionService().encrypt((Object)value) + "(&^#&)";
        }
        return value;
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModuleService responsibleModuleService;
        String docNum;
        String referencesToRefresh;
        String supressActions;
        String lookedUpCollectionName;
        String extraButtonParams;
        String extraButtonSource;
        String hideReturnLink;
        String readOnlyFields;
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        this.validateLookupInquiryFullParameter(request, form, fullParameter);
        KualiForm kualiForm = (KualiForm)form;
        kualiForm.registerEditableProperty(METHOD_TO_CALL);
        String baseLookupUrl = StringUtils.substringBetween((String)fullParameter, (String)"(::::;", (String)";::::)");
        String boClassName = StringUtils.substringBetween((String)fullParameter, (String)"(!!", (String)"!!)");
        if (StringUtils.isBlank((String)boClassName)) {
            throw new RuntimeException("Illegal call to perform lookup, no business object class name specified.");
        }
        Class<?> boClass = null;
        try {
            boClass = Class.forName(boClassName);
        }
        catch (ClassNotFoundException cnfex) {
            if (StringUtils.isNotEmpty((String)baseLookupUrl) && baseLookupUrl.startsWith(KualiAction.getApplicationBaseUrl() + "/kr/") || StringUtils.isEmpty((String)baseLookupUrl)) {
                throw new IllegalArgumentException("The class (" + boClassName + ") cannot be found by this particular " + "application. " + "ApplicationBaseUrl: " + KualiAction.getApplicationBaseUrl() + " ; baseLookupUrl: " + baseLookupUrl);
            }
            LOG.info((Object)("The class (" + boClassName + ") cannot be found by this particular application. " + "ApplicationBaseUrl: " + KualiAction.getApplicationBaseUrl() + " ; baseLookupUrl: " + baseLookupUrl));
        }
        Properties parameters = new Properties();
        String conversionFields = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        if (StringUtils.isNotBlank((String)conversionFields)) {
            String[] fieldConversions;
            parameters.put("conversionFields", conversionFields);
            for (String fieldConversion : fieldConversions = conversionFields.split(",")) {
                String destination = fieldConversion.split(":", 2)[1];
                kualiForm.registerEditableProperty(destination);
            }
        }
        String parameterFields = StringUtils.substringBetween((String)fullParameter, (String)"((`", (String)"`))");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fullParameter: " + fullParameter));
            LOG.debug((Object)("parameterFields: " + parameterFields));
        }
        if (StringUtils.isNotBlank((String)parameterFields)) {
            Object[] lookupParams = parameterFields.split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("lookupParams: " + Arrays.toString(lookupParams)));
            }
            for (Object lookupParam : lookupParams) {
                Object[] keyValue = ((String)lookupParam).split(":", 2);
                if (keyValue.length != 2) {
                    throw new RuntimeException("malformed field conversion pair: " + Arrays.toString(keyValue));
                }
                String lookupParameterValue = this.retrieveLookupParameterValue(boClass, keyValue[1], keyValue[0], form, request);
                if (StringUtils.isNotBlank((String)lookupParameterValue)) {
                    parameters.put(keyValue[1], lookupParameterValue);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("keyValue[0]: " + (String)keyValue[0]));
                LOG.debug((Object)("keyValue[1]: " + (String)keyValue[1]));
            }
        }
        if (StringUtils.isNotBlank((String)(readOnlyFields = StringUtils.substringBetween((String)fullParameter, (String)"((&", (String)"&))")))) {
            parameters.put("readOnlyFields", readOnlyFields);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fullParameter: " + fullParameter));
            LOG.debug((Object)("readOnlyFields: " + readOnlyFields));
        }
        if (StringUtils.isNotBlank((String)(hideReturnLink = StringUtils.substringBetween((String)fullParameter, (String)"((<", (String)">))")))) {
            parameters.put("hideReturnLink", hideReturnLink);
        }
        if (StringUtils.isNotBlank((String)(extraButtonSource = StringUtils.substringBetween((String)fullParameter, (String)"(([", (String)"]))")))) {
            parameters.put("extraButtonSource", extraButtonSource);
        }
        if (StringUtils.isNotBlank((String)(extraButtonParams = StringUtils.substringBetween((String)fullParameter, (String)"((*", (String)"*))")))) {
            parameters.put("extraButtonParams", extraButtonParams);
        }
        String lookupAction = "lookup.do";
        boolean isMultipleValue = false;
        String multipleValues = StringUtils.substringBetween((String)fullParameter, (String)"((%", (String)"%))");
        if (new Boolean(multipleValues).booleanValue()) {
            parameters.put("multipleValues", multipleValues);
            lookupAction = "multipleValueLookup.do";
            isMultipleValue = true;
        }
        if (StringUtils.isNotBlank((String)(lookedUpCollectionName = StringUtils.substringBetween((String)fullParameter, (String)"(:;", (String)";:)")))) {
            parameters.put("lookedUpCollectionName", lookedUpCollectionName);
        }
        if (StringUtils.isNotBlank((String)(supressActions = StringUtils.substringBetween((String)fullParameter, (String)"((^", (String)"^))")))) {
            parameters.put("suppressActions", supressActions);
        }
        if (StringUtils.isNotBlank((String)(referencesToRefresh = StringUtils.substringBetween((String)fullParameter, (String)"((/", (String)"/))")))) {
            parameters.put("referencesToRefresh", referencesToRefresh);
        }
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            parameters.put("lookupAnchor", ((KualiForm)form).getAnchor());
        }
        parameters.put(METHOD_TO_CALL, "start");
        String autoSearch = StringUtils.substringBetween((String)fullParameter, (String)"((~", (String)"~))");
        if (StringUtils.isNotBlank((String)autoSearch)) {
            parameters.put("autoSearch", autoSearch);
            if ("YES".equalsIgnoreCase(autoSearch)) {
                parameters.put(METHOD_TO_CALL, "search");
            }
        }
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey(form));
        parameters.put("businessObjectClassName", boClassName);
        parameters.put("returnLocation", this.getReturnLocation(request, mapping));
        if (form instanceof KualiDocumentFormBase) {
            docNum = ((KualiDocumentFormBase)form).getDocument().getDocumentNumber();
            if (docNum != null) {
                parameters.put("docNum", docNum);
            }
        } else if (form instanceof LookupForm && (docNum = ((LookupForm)form).getDocNum()) != null) {
            parameters.put("docNum", ((LookupForm)form).getDocNum());
        }
        if (boClass != null && (responsibleModuleService = KualiAction.getKualiModuleService().getResponsibleModuleService(boClass)) != null && responsibleModuleService.isExternalizable(boClass)) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            Enumeration<Object> e = parameters.keys();
            while (e.hasMoreElements()) {
                String paramName = (String)e.nextElement();
                parameterMap.put(paramName, parameters.getProperty(paramName));
            }
            return new ActionForward(responsibleModuleService.getExternalizableBusinessObjectLookupUrl(boClass, parameterMap), true);
        }
        if (StringUtils.isBlank((String)baseLookupUrl)) {
            baseLookupUrl = KualiAction.getApplicationBaseUrl() + "/kr/" + lookupAction;
        } else if (isMultipleValue) {
            LookupUtils.transformLookupUrlToMultiple(baseLookupUrl);
        }
        String lookupUrl = UrlFactory.parameterizeUrl(baseLookupUrl, parameters);
        return new ActionForward(lookupUrl, true);
    }

    protected void validateLookupInquiryFullParameter(HttpServletRequest request, ActionForm form, String fullParameter) {
        PojoFormBase pojoFormBase = (PojoFormBase)form;
        if (WebUtils.isFormSessionDocument((PojoFormBase)form) && !pojoFormBase.isPropertyEditable(fullParameter)) {
            throw new RuntimeException("The methodToCallAttribute is not registered as an editable property.");
        }
    }

    public ActionForward performInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        this.validateLookupInquiryFullParameter(request, form, fullParameter);
        KualiForm kualiForm = (KualiForm)form;
        kualiForm.registerEditableProperty(METHOD_TO_CALL);
        String boClassName = StringUtils.substringBetween((String)fullParameter, (String)"(!!", (String)"!!)");
        if (StringUtils.isBlank((String)boClassName)) {
            throw new RuntimeException("Illegal call to perform inquiry, no business object class name specified.");
        }
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", boClassName);
        parameters.put("returnLocation", this.getReturnLocation(request, mapping));
        String parameterFields = StringUtils.substringBetween((String)fullParameter, (String)"((`", (String)"`))");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fullParameter: " + fullParameter));
            LOG.debug((Object)("parameterFields: " + parameterFields));
        }
        if (StringUtils.isNotBlank((String)parameterFields)) {
            String[] inquiryParams = parameterFields.split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("inquiryParams: " + inquiryParams));
            }
            Class<?> boClass = Class.forName(boClassName);
            for (String inquiryParam : inquiryParams) {
                String[] keyValue = inquiryParam.split(":", 2);
                String inquiryParameterValue = this.retrieveLookupParameterValue(boClass, keyValue[1], keyValue[0], form, request);
                if (inquiryParameterValue == null) {
                    parameters.put(keyValue[1], "directInquiryKeyNotSpecified");
                } else {
                    parameters.put(keyValue[1], inquiryParameterValue);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("keyValue[0]: " + keyValue[0]));
                LOG.debug((Object)("keyValue[1]: " + keyValue[1]));
            }
        }
        parameters.put(METHOD_TO_CALL, "start");
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey(form));
        String inquiryUrl = null;
        try {
            Class.forName(boClassName);
            inquiryUrl = KualiAction.getApplicationBaseUrl() + "/kr/" + "directInquiry.do";
        }
        catch (ClassNotFoundException ex) {
            LOG.warn((Object)("Class name does not represent a valid class which this application understands: " + boClassName));
        }
        inquiryUrl = UrlFactory.parameterizeUrl(inquiryUrl, parameters);
        return new ActionForward(inquiryUrl, true);
    }

    protected ActionForward performQuestionWithoutInput(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String questionText, String questionType, String caller, String context) throws Exception {
        return this.performQuestion(mapping, form, request, response, questionId, questionText, questionType, caller, context, false, "", "", "", "");
    }

    protected ActionForward performQuestionWithInput(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String questionText, String questionType, String caller, String context) throws Exception {
        return this.performQuestion(mapping, form, request, response, questionId, questionText, questionType, caller, context, true, "", "", "", "");
    }

    protected ActionForward performQuestionWithInputAgainBecauseOfErrors(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String questionText, String questionType, String caller, String context, String reason, String errorKey, String errorPropertyName, String errorParameter) throws Exception {
        return this.performQuestion(mapping, form, request, response, questionId, questionText, questionType, caller, context, true, reason, errorKey, errorPropertyName, errorParameter);
    }

    private ActionForward performQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String questionText, String questionType, String caller, String context, boolean showReasonField, String reason, String errorKey, String errorPropertyName, String errorParameter) throws Exception {
        String docNum;
        Properties parameters = new Properties();
        parameters.put(METHOD_TO_CALL, "start");
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey(form));
        parameters.put("caller", caller);
        parameters.put("questionIndex", questionId);
        parameters.put("questionType", questionType);
        parameters.put("returnLocation", this.getReturnLocation(request, mapping));
        parameters.put("context", context);
        parameters.put("showReasonField", Boolean.toString(showReasonField));
        parameters.put("reason", reason);
        parameters.put("questionErrorKey", errorKey);
        parameters.put("questionErrorPropertyName", errorPropertyName);
        parameters.put("questionErrorParameter", errorParameter);
        parameters.put("questionAnchor", form instanceof KualiForm ? ObjectUtils.toString((Object)((KualiForm)form).getAnchor()) : "");
        Object methodToCallAttribute = request.getAttribute("methodToCallAttribute");
        if (methodToCallAttribute != null) {
            parameters.put("methodToCallPath", methodToCallAttribute);
            ((PojoForm)form).registerEditableProperty(String.valueOf(methodToCallAttribute));
        }
        if (form instanceof KualiDocumentFormBase && (docNum = ((KualiDocumentFormBase)form).getDocument().getDocumentNumber()) != null) {
            parameters.put("docNum", ((KualiDocumentFormBase)form).getDocument().getDocumentNumber());
        }
        String questionTextAttributeName = "questionText" + questionId;
        GlobalVariables.getUserSession().addObject(questionTextAttributeName, questionText);
        String questionUrl = UrlFactory.parameterizeUrl(KualiAction.getApplicationBaseUrl() + "/kr/" + "questionPrompt.do", parameters);
        return new ActionForward(questionUrl, true);
    }

    public ActionForward performWorkgroupLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String returnUrl = null;
        returnUrl = "/kr".equals(mapping.getModuleConfig().getPrefix()) ? KualiAction.getApplicationBaseUrl() + mapping.getModuleConfig().getPrefix() + mapping.getPath() + ".do" : KualiAction.getApplicationBaseUrl() + mapping.getPath() + ".do";
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String conversionFields = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        String deploymentBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
        String workgroupLookupUrl = deploymentBaseUrl + "/Lookup.do?lookupableImplServiceName=WorkGroupLookupableImplService&methodToCall=start&docFormKey=" + GlobalVariables.getUserSession().addObjectWithGeneratedKey(form);
        if (conversionFields != null) {
            workgroupLookupUrl = workgroupLookupUrl + "&conversionFields=" + conversionFields;
        }
        if (form instanceof KualiDocumentFormBase) {
            workgroupLookupUrl = workgroupLookupUrl + "&docNum=" + ((KualiDocumentFormBase)form).getDocument().getDocumentNumber();
        }
        workgroupLookupUrl = workgroupLookupUrl + "&returnLocation=" + returnUrl;
        return new ActionForward(workgroupLookupUrl, true);
    }

    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String headerTabDispatch = this.getHeaderTabDispatch(request);
        if (StringUtils.isNotEmpty((String)headerTabDispatch)) {
            ActionForward forward = this.dispatchMethod(mapping, form, request, response, headerTabDispatch);
            if (GlobalVariables.getMessageMap().getNumberOfPropertiesWithErrors() > 0) {
                return mapping.findForward("basic");
            }
            this.doTabOpenOrClose(mapping, form, request, response, false);
            if (forward.getRedirect()) {
                return forward;
            }
        }
        return this.dispatchMethod(mapping, form, request, response, this.getHeaderTabNavigateTo(request));
    }

    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        HashMap<String, String> roleQualifier = new HashMap<String, String>(this.getRoleQualification(form, methodToCall));
        Map<String, String> permissionDetails = KRADUtils.getNamespaceAndActionClass(((Object)((Object)this)).getClass());
        if (!KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(principalId, "KR-NS", "Use Screen", permissionDetails, roleQualifier)) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), methodToCall, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected Map<String, String> getRoleQualification(ActionForm form, String methodToCall) {
        return new HashMap<String, String>();
    }

    protected static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    public ActionForward updateTextArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String docWebScope;
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s%n%s", form.getClass().getSimpleName(), request.getRequestURI());
            LOG.trace((Object)lm);
        }
        String[] keyValue = this.getTextAreaParams(request);
        request.setAttribute(TEXT_AREA_FIELD_NAME, (Object)keyValue[0]);
        request.setAttribute(FORM_ACTION, (Object)keyValue[1]);
        request.setAttribute(TEXT_AREA_FIELD_LABEL, (Object)keyValue[2]);
        request.setAttribute(TEXT_AREA_READ_ONLY, (Object)keyValue[3]);
        request.setAttribute(TEXT_AREA_MAX_LENGTH, (Object)keyValue[4]);
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            request.setAttribute(TEXT_AREA_FIELD_ANCHOR, (Object)((KualiForm)form).getAnchor());
        }
        if ((docWebScope = (String)request.getAttribute("documentWebScope")) != null && docWebScope.trim().length() >= 0) {
            request.setAttribute("documentWebScope", (Object)docWebScope);
        }
        request.setAttribute("docFormKey", (Object)GlobalVariables.getUserSession().addObjectWithGeneratedKey(form));
        ActionForward forward = mapping.findForward(FORWARD_TEXT_AREA_UPDATE);
        if (LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", forward == null ? "null" : forward.getPath());
            LOG.trace((Object)lm);
        }
        return forward;
    }

    private String[] getTextAreaParams(HttpServletRequest request) {
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String parameterFields = StringUtils.substringBetween((String)fullParameter, (String)"((`", (String)"`))");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fullParameter: " + fullParameter));
            LOG.debug((Object)("parameterFields: " + parameterFields));
        }
        String[] keyValue = null;
        if (StringUtils.isNotBlank((String)parameterFields)) {
            String[] textAreaParams = parameterFields.split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("lookupParams: " + textAreaParams));
            }
            for (String textAreaParam : textAreaParams) {
                keyValue = textAreaParam.split(":", 2);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("keyValue[0]: " + keyValue[0]));
                LOG.debug((Object)("keyValue[1]: " + keyValue[1]));
                LOG.debug((Object)("keyValue[2]: " + keyValue[2]));
                LOG.debug((Object)("keyValue[3]: " + keyValue[3]));
                LOG.debug((Object)("keyValue[4]: " + keyValue[4]));
            }
        }
        return keyValue;
    }

    public ActionForward postTextAreaToParent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardingId;
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s%n%s", form.getClass().getSimpleName(), request.getRequestURI());
            LOG.trace((Object)lm);
        }
        if ((forwardingId = request.getParameter(FORWARD_NEXT)) == null) {
            forwardingId = "basic";
        }
        ActionForward forward = mapping.findForward(forwardingId);
        if (LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", forward == null ? "null" : forward.getPath());
            LOG.trace((Object)lm);
        }
        return forward;
    }

    protected final void addMethodToCallToUncheckedList(String methodToCall) {
        this.methodToCallsToNotCheckAuthorization.add(methodToCall);
    }

    protected void doProcessingAfterPost(KualiForm form, HttpServletRequest request) {
    }

    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (businessObjectAuthorizationService == null) {
            businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return businessObjectAuthorizationService;
    }

    protected EncryptionService getEncryptionService() {
        if (encryptionService == null) {
            encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return encryptionService;
    }

    public static String getApplicationBaseUrl() {
        if (applicationBaseUrl == null) {
            applicationBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
        }
        return applicationBaseUrl;
    }

    protected boolean isModuleLocked(ActionForm form, String methodToCall, HttpServletRequest request) {
        String boClass = request.getParameter("businessObjectClassName");
        ModuleService moduleService = null;
        if (StringUtils.isNotBlank((String)boClass)) {
            try {
                moduleService = KualiAction.getKualiModuleService().getResponsibleModuleService(Class.forName(boClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warn((Object)("BO class not found: " + boClass), (Throwable)classNotFoundException);
            }
        } else {
            moduleService = KualiAction.getKualiModuleService().getResponsibleModuleService(((Object)((Object)this)).getClass());
        }
        if (moduleService != null && moduleService.isLocked()) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String namespaceCode = "KR-SYS";
            String permissionName = "Access Locked Module";
            Map<String, String> qualification = this.getRoleQualification(form, methodToCall);
            if (!KimApiServiceLocator.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, qualification)) {
                String messageParamName;
                String messageParamComponentCode;
                String messageParamNamespaceCode;
                ParameterService parameterSerivce = CoreFrameworkServiceLocator.getParameterService();
                String lockoutMessage = parameterSerivce.getParameterValueAsString(messageParamNamespaceCode = moduleService.getModuleConfiguration().getNamespaceCode(), messageParamComponentCode = "All", messageParamName = "OLTP_LOCKOUT_MESSAGE");
                if (StringUtils.isBlank((String)lockoutMessage)) {
                    String defaultMessageParamName = "OLTP_LOCKOUT_DEFAULT_MESSAGE";
                    lockoutMessage = parameterSerivce.getParameterValueAsString("KR-NS", messageParamComponentCode, defaultMessageParamName);
                }
                request.setAttribute("moduleLockedMessage", (Object)lockoutMessage);
                return true;
            }
        }
        return false;
    }
}

