/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.RedirectingActionForward;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.kns.web.struts.form.InquiryForm;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Exporter;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableAttachment;
import org.kuali.kfs.krad.bo.PersistableAttachmentList;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class KualiInquiryAction
extends KualiAction {
    private static final Logger LOG = Logger.getLogger(KualiInquiryAction.class);
    private NoteService noteService;

    @Override
    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        if (!(form instanceof InquiryForm)) {
            super.checkAuthorization(form, methodToCall);
        } else {
            try {
                if (!"downloadBOAttachment".equals(methodToCall)) {
                    Class<?> businessObjectClass = Class.forName(((InquiryForm)form).getBusinessObjectClassName());
                    if (!KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPrincipalId(), "KR-NS", "Inquire Into Records", KRADUtils.getNamespaceAndComponentSimpleName(businessObjectClass), Collections.emptyMap())) {
                        throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "inquire", businessObjectClass.getSimpleName());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Unable to load BusinessObject class: " + ((InquiryForm)form).getBusinessObjectClassName()), (Throwable)e);
                super.checkAuthorization(form, methodToCall);
            }
        }
    }

    @Override
    protected Map<String, String> getRoleQualification(ActionForm form, String methodToCall) {
        Map<String, String> primaryKeys;
        Map<String, String> roleQualification = super.getRoleQualification(form, methodToCall);
        if (form instanceof InquiryForm && (primaryKeys = ((InquiryForm)form).getInquiryPrimaryKeys()) != null) {
            for (String keyName : primaryKeys.keySet()) {
                roleQualification.put(keyName, primaryKeys.get(keyName));
            }
        }
        return roleQualification;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("maintenanceViewMode", (Object)"inquiry");
        return super.execute(mapping, form, request, response);
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error((Object)"Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        Class<?> boClass = Class.forName(inquiryForm.getBusinessObjectClassName());
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(boClass)) {
            String redirectUrl = responsibleModuleService.getExternalizableBusinessObjectInquiryUrl(boClass, request.getParameterMap());
            RedirectingActionForward redirectingActionForward = new RedirectingActionForward(redirectUrl);
            redirectingActionForward.setModule("/");
            return redirectingActionForward;
        }
        return this.continueWithInquiry(mapping, form, request, response);
    }

    public ActionForward downloadAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        int line = this.getSelectedLine(request);
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        if (line < 0) {
            PersistableAttachment attachment;
            if (bo instanceof PersistableAttachment && StringUtils.isNotBlank((String)(attachment = (PersistableAttachment)bo).getFileName()) && attachment.getAttachmentContent() != null) {
                this.streamToResponse(attachment.getAttachmentContent(), attachment.getFileName(), attachment.getContentType(), response);
            }
        } else if (bo instanceof PersistableAttachmentList) {
            PersistableAttachmentList attachmentsBo = (PersistableAttachmentList)bo;
            if (CollectionUtils.isEmpty(attachmentsBo.getAttachments())) {
                return null;
            }
            List attachments = attachmentsBo.getAttachments();
            if (CollectionUtils.isNotEmpty(attachments) && attachments.size() > line) {
                PersistableAttachment attachment = (PersistableAttachment)attachmentsBo.getAttachments().get(line);
                this.streamToResponse(attachment.getAttachmentContent(), attachment.getFileName(), attachment.getContentType(), response);
            }
        }
        return null;
    }

    public ActionForward downloadCustomBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = request.getParameter("fileName");
        String contentType = request.getParameter("contentType");
        String fileContentBoField = request.getParameter("fileContentBOField");
        if (fileName != null && contentType != null && fileContentBoField != null) {
            this.checkAuthorization(form, this.findMethodToCall(form, request));
            fileName = StringUtils.replace((String)fileName, (String)" ", (String)"_");
            InquiryForm inquiryForm = (InquiryForm)form;
            BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
            this.checkBO(bo);
            Class<?> clazz = bo.getClass();
            Method method = clazz.getMethod("get" + StringUtils.capitalize((String)fileContentBoField), new Class[0]);
            byte[] fileContents = (byte[])method.invoke((Object)bo, new Object[0]);
            this.streamToResponse(fileContents, fileName, contentType, response);
        } else {
            if (fileName == null) {
                LOG.error((Object)"Request Parameter \"fileName\" not provided.");
            }
            if (contentType == null) {
                LOG.error((Object)"Request Parameter \"contentType\" not provided.");
            }
            if (fileContentBoField == null) {
                LOG.error((Object)"Request Parameter \"fileContentBOField\" not provided.");
            }
        }
        return null;
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long noteIdentifier = Long.valueOf(request.getParameter("noteIdentifier"));
        Note note = this.getNoteService().getNoteByNoteId(noteIdentifier);
        if (note != null) {
            Attachment attachment = note.getAttachment();
            if (attachment != null) {
                attachment.setNote(note);
                WebUtils.saveMimeInputStreamAsFile(response, attachment.getAttachmentMimeTypeCode(), attachment.getAttachmentContents(), attachment.getAttachmentFileName(), attachment.getAttachmentFileSize().intValue());
            }
            return null;
        }
        return mapping.findForward("basic");
    }

    public ActionForward continueWithInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error((Object)"Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        return mapping.findForward("basic");
    }

    public ActionForward toggleInactiveRecordDisplay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error((Object)"Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        String collectionName = this.extractCollectionName(request, "toggleInactiveRecordDisplay");
        if (collectionName == null) {
            LOG.error((Object)"Unable to get find collection name in request.");
            throw new RuntimeException("Unable to get find collection class in request.");
        }
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        boolean showInactive = Boolean.parseBoolean(StringUtils.substringBetween((String)parameterName, (String)"(!!", (String)"."));
        kualiInquirable.setShowInactiveRecords(collectionName, showInactive);
        this.populateSections(mapping, request, inquiryForm, bo);
        if (showInactive) {
            WebUtils.reopenInactiveRecords(inquiryForm.getSections(), inquiryForm.getTabStates(), collectionName);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward toggleTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error((Object)"Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        return super.toggleTab(mapping, form, request, response);
    }

    @Override
    public ActionForward hideAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error((Object)"Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        return super.hideAllTabs(mapping, form, request, response);
    }

    @Override
    public ActionForward showAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error((Object)"Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        return super.showAllTabs(mapping, form, request, response);
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.isCanExport()) {
            BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
            this.checkBO(bo);
            if (bo != null) {
                BusinessObjectEntry businessObjectEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(inquiryForm.getBusinessObjectClassName());
                Class<? extends Exporter> exporterClass = businessObjectEntry.getExporterClass();
                if (exporterClass != null) {
                    Exporter exporter = exporterClass.newInstance();
                    response.setContentType("application/xml");
                    response.setHeader("Content-disposition", "attachment; filename=export.xml");
                    exporter.export(businessObjectEntry.getBusinessObjectClass(), Collections.singletonList(bo), "xml", (OutputStream)response.getOutputStream());
                }
            } else {
                this.populateSections(mapping, request, inquiryForm, bo);
                return mapping.findForward("basic");
            }
        }
        return null;
    }

    protected String extractCollectionName(HttpServletRequest request, String methodToCall) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String collectionName = null;
        if (StringUtils.isNotBlank((String)parameterName)) {
            collectionName = StringUtils.substringBetween((String)parameterName, (String)(methodToCall + "."), (String)".(");
        }
        return collectionName;
    }

    protected BusinessObject retrieveBOFromInquirable(InquiryForm inquiryForm) {
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        BusinessObject bo = kualiInquirable.getBusinessObject(inquiryForm.retrieveInquiryDecryptedPrimaryKeys());
        if (bo == null) {
            LOG.error((Object)"No records found in inquiry action.");
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inquiry", new String[0]);
        }
        return bo;
    }

    protected void populateSections(ActionMapping mapping, HttpServletRequest request, InquiryForm inquiryForm, BusinessObject bo) {
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        if (bo != null) {
            List<Section> sections = kualiInquirable.getSections(bo);
            inquiryForm.setSections(sections);
            kualiInquirable.addAdditionalSections(sections, bo);
        } else {
            inquiryForm.setSections(this.getEmptySections(kualiInquirable.getTitle()));
        }
        request.setAttribute("cf.kualiInquirable", (Object)kualiInquirable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamToResponse(byte[] fileContents, String fileName, String fileContentType, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(fileContents.length);
            baos.write(fileContents);
            WebUtils.saveMimeOutputStreamAsFile(response, fileContentType, baos, fileName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.error((Object)"Error while downloading attachment");
                throw new RuntimeException("IOException occurred while downloading attachment", ioEx);
            }
        }
    }

    private List<Section> getEmptySections(String title) {
        Row row = new Row(Collections.emptyList());
        Section section = new Section(Collections.singletonList(row));
        section.setErrorKey("*");
        section.setSectionTitle(title != null ? title : "");
        section.setNumberOfColumns(0);
        return Collections.singletonList(section);
    }

    private void checkBO(BusinessObject bo) {
        if (bo == null && GlobalVariables.getMessageMap().hasNoMessages()) {
            throw new UnsupportedOperationException("The record you have inquired on does not exist.");
        }
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }
}

