/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.criteria;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.joda.time.DateTime;
import org.kuali.kfs.krad.criteria.CriteriaLookupDao;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CompositePredicate;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PropertyPathPredicate;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class CriteriaLookupDaoOjb
extends PlatformAwareDaoBaseOjb
implements CriteriaLookupDao {
    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria) {
        return this.lookup(queryClass, criteria, LookupCustomizer.Builder.create().build());
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria, LookupCustomizer<T> customizer) {
        if (queryClass == null) {
            throw new IllegalArgumentException("queryClass is null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        if (customizer == null) {
            throw new IllegalArgumentException("customizer is null");
        }
        Criteria parent = new Criteria();
        if (criteria.getPredicate() != null) {
            this.addPredicate(criteria.getPredicate(), parent, (LookupCustomizer.Transform<Predicate, Predicate>)customizer.getPredicateTransform());
        }
        switch (criteria.getCountFlag()) {
            case ONLY: {
                return this.forCountOnly(queryClass, criteria, parent);
            }
            case NONE: {
                return this.forRowResults(queryClass, criteria, parent, criteria.getCountFlag(), customizer.getResultTransform());
            }
            case INCLUDE: {
                return this.forRowResults(queryClass, criteria, parent, criteria.getCountFlag(), customizer.getResultTransform());
            }
        }
        throw new UnsupportedCountFlagException(criteria.getCountFlag());
    }

    private <T> GenericQueryResults<T> forRowResults(Class<T> queryClass, QueryByCriteria criteria, Criteria ojbCriteria, CountFlag flag, LookupCustomizer.Transform<T, T> transform) {
        org.apache.ojb.broker.query.QueryByCriteria ojbQuery = QueryFactory.newQuery(queryClass, (Criteria)ojbCriteria);
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        if (flag == CountFlag.INCLUDE) {
            results.setTotalRowCount(Integer.valueOf(this.getPersistenceBrokerTemplate().getCount((Query)ojbQuery)));
        }
        int startAtIndex = criteria.getStartAtIndex() != null ? criteria.getStartAtIndex() + 1 : 1;
        ojbQuery.setStartAtIndex(startAtIndex);
        if (criteria.getMaxResults() != null) {
            ojbQuery.setEndAtIndex(criteria.getMaxResults() + startAtIndex);
        }
        ArrayList rows = new ArrayList(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)ojbQuery));
        if (criteria.getMaxResults() != null && rows.size() > criteria.getMaxResults()) {
            results.setMoreResultsAvailable(true);
            rows.remove(criteria.getMaxResults());
        }
        results.setResults(CriteriaLookupDaoOjb.transformResults(rows, transform));
        return results.build();
    }

    private static <T> List<T> transformResults(List<T> results, LookupCustomizer.Transform<T, T> transform) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (T r : results) {
            list.add(transform.apply(r));
        }
        return list;
    }

    private <T> GenericQueryResults<T> forCountOnly(Class<T> queryClass, QueryByCriteria criteria, Criteria ojbCriteria) {
        org.apache.ojb.broker.query.QueryByCriteria ojbQuery = QueryFactory.newQuery(queryClass, (Criteria)ojbCriteria);
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        results.setTotalRowCount(Integer.valueOf(this.getPersistenceBrokerTemplate().getCount((Query)ojbQuery)));
        return results.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPredicate(Predicate p, Criteria parent, LookupCustomizer.Transform<Predicate, Predicate> transform) {
        if ((p = (Predicate)transform.apply((Object)p)) instanceof PropertyPathPredicate) {
            String pp = ((PropertyPathPredicate)p).getPropertyPath();
            if (p instanceof NotNullPredicate) {
                parent.addNotNull(pp);
                return;
            } else if (p instanceof NullPredicate) {
                parent.addIsNull(pp);
                return;
            } else if (p instanceof SingleValuedPredicate) {
                this.addSingleValuePredicate((SingleValuedPredicate)p, parent);
                return;
            } else {
                if (!(p instanceof MultiValuedPredicate)) throw new UnsupportedPredicateException(p);
                this.addMultiValuePredicate((MultiValuedPredicate)p, parent);
            }
            return;
        } else {
            if (!(p instanceof CompositePredicate)) throw new UnsupportedPredicateException(p);
            this.addCompositePredicate((CompositePredicate)p, parent, transform);
        }
    }

    private void addSingleValuePredicate(SingleValuedPredicate p, Criteria parent) {
        Object value = CriteriaLookupDaoOjb.getVal(p.getValue());
        String pp = p.getPropertyPath();
        if (p instanceof EqualPredicate) {
            parent.addEqualTo(pp, value);
        } else if (p instanceof EqualIgnoreCasePredicate) {
            parent.addEqualTo(this.genUpperFunc(pp), (Object)((String)value).toUpperCase());
        } else if (p instanceof GreaterThanOrEqualPredicate) {
            parent.addGreaterOrEqualThan((Object)pp, value);
        } else if (p instanceof GreaterThanPredicate) {
            parent.addGreaterThan((Object)pp, value);
        } else if (p instanceof LessThanOrEqualPredicate) {
            parent.addLessOrEqualThan((Object)pp, value);
        } else if (p instanceof LessThanPredicate) {
            parent.addLessThan((Object)pp, value);
        } else if (p instanceof LikePredicate) {
            parent.addLike((Object)this.genUpperFunc(pp), (Object)((String)value).toUpperCase());
        } else if (p instanceof NotEqualPredicate) {
            parent.addNotEqualTo((Object)pp, value);
        } else if (p instanceof NotEqualIgnoreCasePredicate) {
            parent.addNotEqualTo((Object)this.genUpperFunc(pp), (Object)((String)value).toUpperCase());
        } else if (p instanceof NotLikePredicate) {
            parent.addNotLike(pp, value);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    private void addMultiValuePredicate(MultiValuedPredicate p, Criteria parent) {
        String pp = p.getPropertyPath();
        if (p instanceof InPredicate) {
            Set<?> values = CriteriaLookupDaoOjb.getVals(p.getValues());
            parent.addIn(pp, values);
        } else if (p instanceof InIgnoreCasePredicate) {
            Set<String> values = CriteriaLookupDaoOjb.toUpper(CriteriaLookupDaoOjb.getValsUnsafe(((InIgnoreCasePredicate)p).getValues()));
            parent.addIn(this.genUpperFunc(pp), values);
        } else if (p instanceof NotInPredicate) {
            Set<?> values = CriteriaLookupDaoOjb.getVals(p.getValues());
            parent.addNotIn(pp, values);
        } else if (p instanceof NotInIgnoreCasePredicate) {
            Set<String> values = CriteriaLookupDaoOjb.toUpper(CriteriaLookupDaoOjb.getValsUnsafe(((NotInIgnoreCasePredicate)p).getValues()));
            parent.addNotIn(this.genUpperFunc(pp), values);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    private void addCompositePredicate(CompositePredicate p, Criteria parent, LookupCustomizer.Transform<Predicate, Predicate> transform) {
        for (Predicate ip : p.getPredicates()) {
            Criteria inner = new Criteria();
            this.addPredicate(ip, inner, transform);
            if (p instanceof AndPredicate) {
                parent.addAndCriteria(inner);
                continue;
            }
            if (p instanceof OrPredicate) {
                parent.addOrCriteria(inner);
                continue;
            }
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    private static <U extends CriteriaValue<?>> Object getVal(U toConv) {
        Object o = toConv.getValue();
        if (o instanceof DateTime) {
            return new Timestamp(((DateTime)o).getMillis());
        }
        return o;
    }

    private static <T, U extends CriteriaValue<T>> Set<T> getValsUnsafe(Set<? extends U> toConv) {
        return CriteriaLookupDaoOjb.getVals(toConv);
    }

    private static Set<?> getVals(Set<? extends CriteriaValue<?>> toConv) {
        HashSet<Object> values = new HashSet<Object>();
        for (CriteriaValue<?> value : toConv) {
            values.add(CriteriaLookupDaoOjb.getVal(value));
        }
        return values;
    }

    private static Set<String> toUpper(Set<String> strs) {
        HashSet<String> values = new HashSet<String>();
        for (String value : strs) {
            values.add(value.toUpperCase());
        }
        return values;
    }

    private String getUpperFunction() {
        return this.getDbPlatform().getUpperCaseFunction();
    }

    private String genUpperFunc(String pp) {
        return this.getUpperFunction() + "(" + pp + ")";
    }

    private static class UnsupportedCountFlagException
    extends RuntimeException {
        private UnsupportedCountFlagException(CountFlag flag) {
            super("Unsupported predicate [" + String.valueOf(flag) + "]");
        }
    }

    private static class UnsupportedPredicateException
    extends RuntimeException {
        private UnsupportedPredicateException(Predicate predicate) {
            super("Unsupported predicate [" + String.valueOf(predicate) + "]");
        }
    }
}

