/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.CollectionDefinition;
import org.kuali.kfs.krad.datadictionary.ComplexAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;

public abstract class DataDictionaryEntryBase
implements DataDictionaryEntry,
Serializable,
InitializingBean {
    protected List<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
    protected List<ComplexAttributeDefinition> complexAttributes = new ArrayList<ComplexAttributeDefinition>();
    protected List<CollectionDefinition> collections = new ArrayList<CollectionDefinition>();
    protected List<RelationshipDefinition> relationships = new ArrayList<RelationshipDefinition>();
    protected Map<String, AttributeDefinition> attributeMap = new LinkedHashMap<String, AttributeDefinition>();
    protected Map<String, ComplexAttributeDefinition> complexAttributeMap = new LinkedHashMap<String, ComplexAttributeDefinition>();
    protected Map<String, CollectionDefinition> collectionMap = new LinkedHashMap<String, CollectionDefinition>();
    protected Map<String, RelationshipDefinition> relationshipMap = new LinkedHashMap<String, RelationshipDefinition>();

    public abstract Class<?> getEntryClass();

    @Override
    public AttributeDefinition getAttributeDefinition(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        return this.attributeMap.get(attributeName);
    }

    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public List<ComplexAttributeDefinition> getComplexAttributes() {
        return this.complexAttributes;
    }

    public void setComplexAttributes(List<ComplexAttributeDefinition> complexAttributes) {
        this.complexAttributeMap.clear();
        for (ComplexAttributeDefinition complexAttribute : complexAttributes) {
            if (complexAttribute == null) {
                throw new IllegalArgumentException("invalid (null) complexAttributeDefinition");
            }
            String complexAttributeName = complexAttribute.getName();
            if (StringUtils.isBlank((String)complexAttributeName)) {
                throw new ValidationException("invalid (blank) collectionName");
            }
            if (this.complexAttributeMap.containsKey(complexAttribute)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttribute + "' already defined as an complex attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.complexAttributeMap.put(complexAttributeName, complexAttribute);
        }
        this.complexAttributes = complexAttributes;
    }

    public CollectionDefinition getCollectionDefinition(String collectionName) {
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        return this.collectionMap.get(collectionName);
    }

    public List<CollectionDefinition> getCollections() {
        return this.collections;
    }

    public RelationshipDefinition getRelationshipDefinition(String relationshipName) {
        if (StringUtils.isBlank((String)relationshipName)) {
            throw new IllegalArgumentException("invalid (blank) relationshipName");
        }
        return this.relationshipMap.get(relationshipName);
    }

    @Override
    public List<RelationshipDefinition> getRelationships() {
        return this.relationships;
    }

    @Override
    public void completeValidation() {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.completeValidation(this.getEntryClass(), null);
        }
        for (CollectionDefinition collectionDefinition : this.collections) {
            collectionDefinition.completeValidation((Class)this.getEntryClass(), (Class)null);
        }
        for (RelationshipDefinition relationshipDefinition : this.relationships) {
            relationshipDefinition.completeValidation((Class)this.getEntryClass(), (Class)null);
        }
    }

    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributeMap.clear();
        for (AttributeDefinition attribute : attributes) {
            if (attribute == null) {
                throw new IllegalArgumentException("invalid (null) attributeDefinition");
            }
            String attributeName = attribute.getName();
            if (StringUtils.isBlank((String)attributeName)) {
                throw new ValidationException("invalid (blank) attributeName");
            }
            if (this.attributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.complexAttributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Complex Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.attributeMap.put(attributeName, attribute);
        }
        this.attributes = attributes;
    }

    public void setCollections(List<CollectionDefinition> collections) {
        this.collectionMap.clear();
        for (CollectionDefinition collection : collections) {
            if (collection == null) {
                throw new IllegalArgumentException("invalid (null) collectionDefinition");
            }
            String collectionName = collection.getName();
            if (StringUtils.isBlank((String)collectionName)) {
                throw new ValidationException("invalid (blank) collectionName");
            }
            if (this.collectionMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.complexAttributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as Complex Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.collectionMap.put(collectionName, collection);
        }
        this.collections = collections;
    }

    public void setRelationships(List<RelationshipDefinition> relationships) {
        this.relationships = relationships;
    }

    public Set<String> getCollectionNames() {
        return this.collectionMap.keySet();
    }

    public Set<String> getAttributeNames() {
        return this.attributeMap.keySet();
    }

    public Set<String> getRelationshipNames() {
        return this.relationshipMap.keySet();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.relationships != null) {
            this.relationshipMap.clear();
            for (RelationshipDefinition relationship : this.relationships) {
                if (relationship == null) {
                    throw new IllegalArgumentException("invalid (null) relationshipDefinition");
                }
                String relationshipName = relationship.getObjectAttributeName();
                if (StringUtils.isBlank((String)relationshipName)) {
                    throw new ValidationException("invalid (blank) relationshipName");
                }
                relationship.setSourceClass(this.getEntryClass());
                this.relationshipMap.put(relationshipName, relationship);
            }
        }
        if (this.complexAttributes != null) {
            for (ComplexAttributeDefinition complexAttribute : this.complexAttributes) {
                this.addNestedAttributes(complexAttribute, complexAttribute.getName());
            }
        }
    }

    private void addNestedAttributes(ComplexAttributeDefinition complexAttribute, String attrPath) {
        DataDictionaryEntryBase dataDictionaryEntry = (DataDictionaryEntryBase)complexAttribute.getDataObjectEntry();
        for (AttributeDefinition attribute : dataDictionaryEntry.getAttributes()) {
            String nestedAttributeName = attrPath + "." + attribute.getName();
            AttributeDefinition nestedAttribute = this.copyAttributeDefinition(attribute);
            nestedAttribute.setName(nestedAttributeName);
            if (this.attributeMap.containsKey(nestedAttributeName)) continue;
            this.attributes.add(nestedAttribute);
            this.attributeMap.put(nestedAttributeName, nestedAttribute);
        }
        List<ComplexAttributeDefinition> nestedComplexAttributes = dataDictionaryEntry.getComplexAttributes();
        if (nestedComplexAttributes != null) {
            for (ComplexAttributeDefinition nestedComplexAttribute : nestedComplexAttributes) {
                this.addNestedAttributes(nestedComplexAttribute, attrPath + "." + nestedComplexAttribute.getName());
            }
        }
    }

    private AttributeDefinition copyAttributeDefinition(AttributeDefinition attrDefToCopy) {
        AttributeDefinition attrDefCopy = new AttributeDefinition();
        try {
            BeanUtils.copyProperties((Object)attrDefToCopy, (Object)attrDefCopy, (String[])new String[]{"formatterClass"});
            attrDefCopy.setRequired(attrDefToCopy.isRequired());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attrDefCopy;
    }
}

