/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.maintenance;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.exception.PessimisticLockingException;
import org.kuali.kfs.krad.maintenance.Maintainable;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataObjectAuthorizationService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.service.MaintenanceDocumentService;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.web.form.MaintenanceForm;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class MaintainableImpl
extends ViewHelperServiceImpl
implements Maintainable {
    private static final long serialVersionUID = 9125271369161634992L;
    private static final Logger LOG = Logger.getLogger(MaintainableImpl.class);
    private String documentNumber;
    private Object dataObject;
    private Class<?> dataObjectClass;
    private String maintenanceAction;
    private transient LookupService lookupService;
    private transient DataObjectAuthorizationService dataObjectAuthorizationService;
    private transient DataObjectMetaDataService dataObjectMetaDataService;
    private transient DocumentDictionaryService documentDictionaryService;
    private transient EncryptionService encryptionService;
    private transient BusinessObjectService businessObjectService;
    private transient MaintenanceDocumentService maintenanceDocumentService;

    @Override
    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        Object dataObject;
        block2: {
            dataObject = null;
            try {
                dataObject = this.getLookupService().findObjectBySearch(this.getDataObjectClass(), dataObjectKeys);
            }
            catch (ClassNotPersistenceCapableException ex) {
                if (document.getOldMaintainableObject().isExternalBusinessObject()) break block2;
                throw new RuntimeException("Data Object Class: " + this.getDataObjectClass() + " is not persistable and is not externalizable - configuration error");
            }
        }
        return dataObject;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public String getDocumentTitle(MaintenanceDocument document) {
        return "";
    }

    @Override
    public Object getDataObject() {
        return this.dataObject;
    }

    @Override
    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    @Override
    public Class getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public void setDataObjectClass(Class dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Override
    public boolean isLockable() {
        return KRADServiceLocator.getPersistenceStructureService().isPersistable(this.getDataObject().getClass());
    }

    @Override
    public PersistableBusinessObject getPersistableBusinessObject() {
        if (KRADServiceLocator.getPersistenceStructureService().isPersistable(this.getDataObject().getClass())) {
            return (PersistableBusinessObject)this.getDataObject();
        }
        return null;
    }

    @Override
    public String getMaintenanceAction() {
        return this.maintenanceAction;
    }

    @Override
    public void setMaintenanceAction(String maintenanceAction) {
        this.maintenanceAction = maintenanceAction;
    }

    @Override
    public List<MaintenanceLock> generateMaintenanceLocks() {
        ArrayList<MaintenanceLock> maintenanceLocks = new ArrayList<MaintenanceLock>();
        StringBuffer lockRepresentation = new StringBuffer(this.dataObjectClass.getName());
        lockRepresentation.append("!!");
        Object bo = this.getDataObject();
        List<String> keyFieldNames = this.getDocumentDictionaryService().getLockingKeys(this.getDocumentTypeName());
        Iterator<String> i = keyFieldNames.iterator();
        while (i.hasNext()) {
            String fieldName = i.next();
            Object fieldValue = ObjectUtils.getPropertyValue(bo, fieldName);
            if (fieldValue == null) {
                fieldValue = "";
            }
            if (this.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.dataObjectClass, fieldName)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        fieldValue = this.getEncryptionService().encrypt(fieldValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error((Object)("Unable to encrypt secure field for locking representation " + e.getMessage()));
                    throw new RuntimeException("Unable to encrypt secure field for locking representation " + e.getMessage());
                }
            }
            lockRepresentation.append(fieldName);
            lockRepresentation.append("^^");
            lockRepresentation.append(String.valueOf(fieldValue));
            if (!i.hasNext()) continue;
            lockRepresentation.append("::");
        }
        MaintenanceLock maintenanceLock = new MaintenanceLock();
        maintenanceLock.setDocumentNumber(this.documentNumber);
        maintenanceLock.setLockingRepresentation(lockRepresentation.toString());
        maintenanceLocks.add(maintenanceLock);
        return maintenanceLocks;
    }

    protected String getDocumentTypeName() {
        return this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.dataObjectClass);
    }

    @Override
    public void saveDataObject() {
        if (!(this.dataObject instanceof PersistableBusinessObject)) {
            throw new RuntimeException("Cannot save object of type: " + this.dataObjectClass + " with business object service");
        }
        this.getBusinessObjectService().linkAndSave((PersistableBusinessObject)this.dataObject);
    }

    @Override
    public void deleteDataObject() {
        if (this.dataObject == null) {
            return;
        }
        if (!(this.dataObject instanceof PersistableBusinessObject)) {
            throw new RuntimeException("Cannot delete object of type: " + this.dataObjectClass + " with business object service");
        }
        this.getBusinessObjectService().delete((PersistableBusinessObject)this.dataObject);
        this.dataObject = null;
    }

    @Override
    public void doRouteStatusChange(DocumentHeader documentHeader) {
    }

    @Override
    public String getLockingDocumentId() {
        return this.getMaintenanceDocumentService().getLockingDocumentId(this, this.documentNumber);
    }

    @Override
    public List<String> getWorkflowEngineDocumentIdsToLock() {
        return null;
    }

    @Override
    public boolean useCustomLockDescriptors() {
        return false;
    }

    @Override
    public String getCustomLockDescriptor(Person user) {
        throw new PessimisticLockingException("The Maintainable for document " + this.documentNumber + " is using pessimistic locking with custom lock descriptors, but the Maintainable has not overridden the getCustomLockDescriptor method");
    }

    @Override
    public boolean isNotesEnabled() {
        return this.getDataObjectMetaDataService().areNotesSupported(this.dataObjectClass);
    }

    @Override
    public boolean isExternalBusinessObject() {
        return false;
    }

    @Override
    public void prepareExternalBusinessObject(BusinessObject businessObject) {
    }

    @Override
    public boolean isOldDataObjectInDocument() {
        boolean isOldDataObjectInExistence = true;
        if (this.getDataObject() == null) {
            isOldDataObjectInExistence = false;
        } else {
            Map<String, ?> keyFieldValues = this.getDataObjectMetaDataService().getPrimaryKeyFieldValues(this.getDataObject());
            for (Object keyValue : keyFieldValues.values()) {
                if (keyValue == null) {
                    isOldDataObjectInExistence = false;
                } else if (keyValue instanceof String && StringUtils.isBlank((String)((String)keyValue))) {
                    isOldDataObjectInExistence = false;
                }
                if (isOldDataObjectInExistence) continue;
                break;
            }
        }
        return isOldDataObjectInExistence;
    }

    @Override
    public void prepareForSave() {
    }

    @Override
    public void processAfterRetrieve() {
    }

    @Override
    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
    }

    @Override
    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    protected void processAfterAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
        super.processAfterAddLine(view, collectionGroup, model, addLine);
        if (model instanceof MaintenanceForm && "Edit".equals(((MaintenanceForm)model).getMaintenanceAction()) && !(addLine instanceof Note)) {
            MaintenanceForm maintenanceForm = (MaintenanceForm)model;
            MaintenanceDocument document = maintenanceForm.getDocument();
            String bindingPrefix = collectionGroup.getBindingInfo().getBindByNamePrefix();
            String propertyPath = collectionGroup.getPropertyName();
            if (bindingPrefix != "" && bindingPrefix != null) {
                propertyPath = bindingPrefix + "." + propertyPath;
            }
            Collection oldCollection = (Collection)ObjectPropertyUtils.getPropertyValue(document.getOldMaintainableObject().getDataObject(), propertyPath);
            try {
                Object blankLine = collectionGroup.getCollectionObjectClass().newInstance();
                oldCollection.add(blankLine);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new line instance for old maintenance object", e);
            }
        }
    }

    @Override
    protected void processAfterDeleteLine(View view, CollectionGroup collectionGroup, Object model, int lineIndex) {
        super.processAfterDeleteLine(view, collectionGroup, model, lineIndex);
        if (model instanceof MaintenanceForm && "Edit".equals(((MaintenanceForm)model).getMaintenanceAction()) && !collectionGroup.getCollectionObjectClass().getName().equals(Note.class.getName())) {
            MaintenanceForm maintenanceForm = (MaintenanceForm)model;
            MaintenanceDocument document = maintenanceForm.getDocument();
            Collection oldCollection = (Collection)ObjectPropertyUtils.getPropertyValue(document.getOldMaintainableObject().getDataObject(), collectionGroup.getPropertyName());
            try {
                oldCollection.remove(oldCollection.toArray()[lineIndex]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to delete line instance for old maintenance object", e);
            }
        }
    }

    protected String getDocumentNumber() {
        return this.documentNumber;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected MaintenanceDocumentService getMaintenanceDocumentService() {
        if (this.maintenanceDocumentService == null) {
            this.maintenanceDocumentService = KRADServiceLocatorWeb.getMaintenanceDocumentService();
        }
        return this.maintenanceDocumentService;
    }

    public void setMaintenanceDocumentService(MaintenanceDocumentService maintenanceDocumentService) {
        this.maintenanceDocumentService = maintenanceDocumentService;
    }
}

