/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.rules;

import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.datadictionary.validation.ErrorLevel;
import org.kuali.kfs.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.maintenance.Maintainable;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.rules.DocumentRuleBase;
import org.kuali.kfs.krad.rules.MaintenanceDocumentRule;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DataObjectAuthorizationService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.InactivationBlockingDetectionService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ForeignKeyFieldsPopulationState;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.RouteToCompletionUtil;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.util.AutoPopulatingList;

public class MaintenanceDocumentRuleBase
extends DocumentRuleBase
implements MaintenanceDocumentRule {
    protected static Logger LOG = Logger.getLogger(MaintenanceDocumentRuleBase.class);
    public static final String MAINTAINABLE_ERROR_PREFIX = "document.newMaintainableObject.";
    public static final String DOCUMENT_ERROR_PREFIX = "document.";
    public static final String MAINTAINABLE_ERROR_PATH = "document.newMaintainableObject";
    private PersistenceStructureService persistenceStructureService;
    private DataDictionaryService ddService;
    private BusinessObjectService boService;
    private DictionaryValidationService dictionaryValidationService;
    private ConfigurationService configService;
    private WorkflowDocumentService workflowDocumentService;
    private PersonService personService;
    private RoleService roleService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private DataObjectAuthorizationService dataObjectAuthorizationService;
    private Object oldDataObject;
    private Object newDataObject;
    private Class dataObjectClass;
    protected List priorErrorPath = new ArrayList();

    @Override
    public boolean processSaveDocument(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        this.clearErrorPath();
        this.setupBaseConvenienceObjects(maintenanceDocument);
        if (!this.isDocumentValidForSave(maintenanceDocument)) {
            this.resumeErrorPath();
            return false;
        }
        if (!this.processCustomSaveDocumentBusinessRules(maintenanceDocument)) {
            this.resumeErrorPath();
            return false;
        }
        this.resumeErrorPath();
        return true;
    }

    @Override
    public boolean processRouteDocument(Document document) {
        LOG.info((Object)"processRouteDocument called");
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        boolean completeRequestPending = RouteToCompletionUtil.checkIfAtleastOneAdHocCompleteRequestExist(maintenanceDocument);
        if (completeRequestPending) {
            return true;
        }
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)MaintenanceDocumentRuleBase.getDocumentDictionaryService().getDocumentAuthorizer(document);
        this.clearErrorPath();
        this.setupBaseConvenienceObjects(maintenanceDocument);
        this.processGlobalSaveDocumentBusinessRules(maintenanceDocument);
        boolean success = true;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved()) {
            try {
                if (!(success &= documentAuthorizer.canCreateOrMaintain((MaintenanceDocument)document, GlobalVariables.getUserSession().getPerson()))) {
                    GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.authorization.document", GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Create/Maintain", MaintenanceDocumentRuleBase.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.newDataObject.getClass()));
                }
            }
            catch (RiceIllegalArgumentException e) {
                GlobalVariables.getMessageMap().putError("Unable to determine authorization due to previous errors", "Unable to determine authorization due to previous errors", new String[0]);
            }
        }
        success &= this.processGlobalRouteDocumentBusinessRules(maintenanceDocument);
        success &= this.processCustomRouteDocumentBusinessRules(maintenanceDocument);
        this.resumeErrorPath();
        return success &= this.processInactivationBlockChecking(maintenanceDocument);
    }

    protected boolean isDocumentInactivatingBusinessObject(MaintenanceDocument maintenanceDocument) {
        Class dataObjectClass;
        if (maintenanceDocument.isEdit() && (dataObjectClass = maintenanceDocument.getNewMaintainableObject().getDataObjectClass()) != null && MutableInactivatable.class.isAssignableFrom(dataObjectClass)) {
            MutableInactivatable oldInactivateableBO = (MutableInactivatable)this.oldDataObject;
            MutableInactivatable newInactivateableBO = (MutableInactivatable)this.newDataObject;
            return oldInactivateableBO.isActive() && !newInactivateableBO.isActive();
        }
        return false;
    }

    protected boolean processInactivationBlockChecking(MaintenanceDocument maintenanceDocument) {
        if (this.isDocumentInactivatingBusinessObject(maintenanceDocument)) {
            Class dataObjectClass = maintenanceDocument.getNewMaintainableObject().getDataObjectClass();
            Set<InactivationBlockingMetadata> inactivationBlockingMetadatas = this.getDataDictionaryService().getAllInactivationBlockingDefinitions(dataObjectClass);
            if (inactivationBlockingMetadatas != null) {
                for (InactivationBlockingMetadata inactivationBlockingMetadata : inactivationBlockingMetadatas) {
                    if (this.processInactivationBlockChecking(maintenanceDocument, inactivationBlockingMetadata)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean processInactivationBlockChecking(MaintenanceDocument maintenanceDocument, InactivationBlockingMetadata inactivationBlockingMetadata) {
        if (this.newDataObject instanceof PersistableBusinessObject) {
            InactivationBlockingDetectionService inactivationBlockingDetectionService;
            boolean foundBlockingRecord;
            String inactivationBlockingDetectionServiceBeanName = inactivationBlockingMetadata.getInactivationBlockingDetectionServiceBeanName();
            if (StringUtils.isBlank((String)inactivationBlockingDetectionServiceBeanName)) {
                inactivationBlockingDetectionServiceBeanName = "cf.inactivationBlockingDetectionService";
            }
            if (foundBlockingRecord = (inactivationBlockingDetectionService = KRADServiceLocatorWeb.getInactivationBlockingDetectionService(inactivationBlockingDetectionServiceBeanName)).hasABlockingRecord((PersistableBusinessObject)this.newDataObject, inactivationBlockingMetadata)) {
                this.putInactivationBlockingErrorOnPage(maintenanceDocument, inactivationBlockingMetadata);
            }
            return !foundBlockingRecord;
        }
        return true;
    }

    protected void putInactivationBlockingErrorOnPage(MaintenanceDocument document, InactivationBlockingMetadata inactivationBlockingMetadata) {
        if (!this.getPersistenceStructureService().hasPrimaryKeyFieldValues(this.newDataObject)) {
            throw new RuntimeException("Maintenance document did not have all primary key values filled in.");
        }
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", inactivationBlockingMetadata.getBlockedBusinessObjectClass().getName());
        parameters.put("methodToCall", "displayAllInactivationBlockers");
        List keys = new ArrayList();
        if (this.getPersistenceStructureService().isPersistable(this.newDataObject.getClass())) {
            keys = this.getPersistenceStructureService().listPrimaryKeyFieldNames(this.newDataObject.getClass());
        }
        String keyName2 = null;
        for (String keyName2 : keys) {
            Object keyValue = null;
            if (keyName2 != null) {
                keyValue = ObjectUtils.getPropertyValue(this.newDataObject, keyName2);
            }
            if (keyValue == null) {
                keyValue = "";
            } else if (keyValue instanceof Date) {
                if (Formatter.findFormatter(keyValue.getClass()) != null) {
                    Formatter formatter = Formatter.getFormatter(keyValue.getClass());
                    keyValue = (String)formatter.format(keyValue);
                }
            } else {
                keyValue = keyValue.toString();
            }
            if (this.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(inactivationBlockingMetadata.getBlockedBusinessObjectClass(), keyName2)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyValue = CoreApiServiceLocator.getEncryptionService().encrypt(keyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error((Object)"Exception while trying to encrypted value for inquiry framework.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            parameters.put(keyName2, keyValue);
        }
        String blockingUrl = UrlFactory.parameterizeUrl("inactivationBlockers.do", parameters);
        GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inactivation.blocked", blockingUrl);
    }

    @Override
    public boolean processApproveDocument(ApproveDocumentEvent approveEvent) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)approveEvent.getDocument();
        this.clearErrorPath();
        this.setupBaseConvenienceObjects(maintenanceDocument);
        this.processGlobalSaveDocumentBusinessRules(maintenanceDocument);
        boolean success = true;
        success &= this.processGlobalApproveDocumentBusinessRules(maintenanceDocument);
        this.resumeErrorPath();
        return success &= this.processCustomApproveDocumentBusinessRules(maintenanceDocument);
    }

    protected void putGlobalError(String errorConstant) {
        if (!this.errorAlreadyExists("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant, new String[0]);
        }
    }

    protected void putGlobalError(String errorConstant, String parameter) {
        if (!this.errorAlreadyExists("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant, parameter);
        }
    }

    protected void putGlobalError(String errorConstant, String[] parameters) {
        if (!this.errorAlreadyExists("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant, parameters);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, new String[0]);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, parameter);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant, String[] parameters) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, parameters);
        }
    }

    protected void putFieldErrorWithShortLabel(String propertyName, String errorConstant) {
        String shortLabel = this.getDataDictionaryService().getAttributeShortLabel(this.dataObjectClass, propertyName);
        this.putFieldError(propertyName, errorConstant, shortLabel);
    }

    protected void putDocumentError(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists(DOCUMENT_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putError(DOCUMENT_ERROR_PREFIX + propertyName, errorConstant, parameter);
        }
    }

    protected void putDocumentError(String propertyName, String errorConstant, String[] parameters) {
        GlobalVariables.getMessageMap().putError(DOCUMENT_ERROR_PREFIX + propertyName, errorConstant, parameters);
    }

    protected boolean errorAlreadyExists(String propertyName, String errorConstant) {
        return GlobalVariables.getMessageMap().fieldHasMessage(propertyName, errorConstant);
    }

    protected void putGlobalsError(String propertyName, String errorConstant) {
        if (!this.errorAlreadyExists(propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(propertyName, errorConstant, new String[0]);
        }
    }

    protected void putGlobalsError(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists(propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(propertyName, errorConstant, parameter);
        }
    }

    protected void clearErrorPath() {
        this.priorErrorPath.addAll(GlobalVariables.getMessageMap().getErrorPath());
        GlobalVariables.getMessageMap().getErrorPath().clear();
    }

    protected void resumeErrorPath() {
        GlobalVariables.getMessageMap().getErrorPath().addAll(this.priorErrorPath);
    }

    protected boolean dataDictionaryValidate(MaintenanceDocument document) {
        boolean success = true;
        LOG.debug((Object)"MaintenanceDocument validation beginning");
        GlobalVariables.getMessageMap().addToErrorPath(MAINTAINABLE_ERROR_PATH);
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (newMaintainable == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath(MAINTAINABLE_ERROR_PATH);
            throw new ValidationException("Maintainable object from Maintenance Document '" + document.getDocumentTitle() + "' is null, unable to proceed.");
        }
        Object dataObject = newMaintainable.getDataObject();
        if (dataObject == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath(MAINTAINABLE_ERROR_PREFIX);
            throw new ValidationException("Maintainable's component business object is null.");
        }
        GlobalVariables.getMessageMap().addToErrorPath("dataObject");
        DictionaryValidationResult dictionaryValidationResult = this.getDictionaryValidationService().validate(this.newDataObject);
        if (dictionaryValidationResult.getNumberOfErrors() > 0) {
            success &= false;
            for (ConstraintValidationResult cvr : dictionaryValidationResult) {
                if (cvr.getStatus() != ErrorLevel.ERROR) continue;
                GlobalVariables.getMessageMap().putError(cvr.getAttributePath(), cvr.getErrorKey(), new String[0]);
            }
        }
        success &= this.getDictionaryValidationService().validateDefaultExistenceChecks((BusinessObject)dataObject);
        GlobalVariables.getMessageMap().removeFromErrorPath("dataObject");
        GlobalVariables.getMessageMap().removeFromErrorPath(MAINTAINABLE_ERROR_PATH);
        LOG.debug((Object)"MaintenanceDocument validation ending");
        return true;
    }

    protected boolean primaryKeyCheck(MaintenanceDocument document) {
        boolean success = true;
        Class dataObjectClass = document.getNewMaintainableObject().getDataObjectClass();
        Object oldBo = document.getOldMaintainableObject().getDataObject();
        Object newDataObject = document.getNewMaintainableObject().getDataObject();
        if (newDataObject instanceof GlobalBusinessObject) {
            return success;
        }
        if (document.isEdit()) {
            if (!this.getDataObjectMetaDataService().equalsByPrimaryKeys(oldBo, newDataObject)) {
                this.putDocumentError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.general.primaryKeysChangedOnEdit", this.getHumanReadablePrimaryKeyFieldNames(dataObjectClass));
                success &= false;
            }
        } else if (document.isNew() && newDataObject instanceof PersistableBusinessObject) {
            Map<String, ?> newPkFields = this.getDataObjectMetaDataService().getPrimaryKeyFieldValues(newDataObject);
            PersistableBusinessObject testBo = this.getBoService().findByPrimaryKey(dataObjectClass.asSubclass(PersistableBusinessObject.class), newPkFields);
            if (testBo != null) {
                this.putDocumentError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.general.objectAlreadyExistsByPrimaryKeysOnCreateNew", this.getHumanReadablePrimaryKeyFieldNames(dataObjectClass));
                success &= false;
            }
        }
        return success;
    }

    protected String getHumanReadablePrimaryKeyFieldNames(Class<?> dataObjectClass) {
        String delim = "";
        StringBuffer pkFieldNames = new StringBuffer();
        List<String> pkFields = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(dataObjectClass);
        for (String pkFieldName : pkFields) {
            String humanReadableFieldName = this.getDataDictionaryService().getAttributeLabel(dataObjectClass, pkFieldName);
            pkFieldNames.append(delim + humanReadableFieldName);
            if (!delim.equalsIgnoreCase("")) continue;
            delim = ", ";
        }
        return pkFieldNames.toString();
    }

    protected boolean processGlobalApproveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean processGlobalRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        return success &= this.checkEmptyDocumentField("documentHeader.documentDescription", document.getDocumentHeader().getDocumentDescription(), "Description");
    }

    protected boolean processGlobalSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        success &= this.primaryKeyCheck(document);
        return success &= this.dataDictionaryValidate(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean isDocumentValidForSave(MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        success &= super.isDocumentOverviewValid(maintenanceDocument);
        success &= this.validateDocumentStructure(maintenanceDocument);
        success &= this.validateMaintenanceDocument(maintenanceDocument);
        return success &= this.validateGlobalBusinessObjectPersistable(maintenanceDocument);
    }

    protected boolean validateDocumentStructure(Document document) {
        boolean success = true;
        String documentHeaderId = document.getDocumentNumber();
        if (documentHeaderId == null || StringUtils.isEmpty((String)documentHeaderId)) {
            throw new ValidationException("Document has no document number, unable to proceed.");
        }
        return success;
    }

    protected boolean validateMaintenanceDocument(MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        Maintainable newMaintainable = maintenanceDocument.getNewMaintainableObject();
        if (newMaintainable == null) {
            throw new ValidationException("Maintainable object from Maintenance Document '" + maintenanceDocument.getDocumentTitle() + "' is null, unable to proceed.");
        }
        if (newMaintainable.getDataObject() == null) {
            throw new ValidationException("Maintainable's component data object is null.");
        }
        return success;
    }

    protected boolean validateGlobalBusinessObjectPersistable(MaintenanceDocument document) {
        boolean success = true;
        if (document.getNewMaintainableObject() == null) {
            return success;
        }
        if (document.getNewMaintainableObject().getDataObject() == null) {
            return success;
        }
        if (!(document.getNewMaintainableObject().getDataObject() instanceof GlobalBusinessObject)) {
            return success;
        }
        PersistableBusinessObject bo = (PersistableBusinessObject)document.getNewMaintainableObject().getDataObject();
        GlobalBusinessObject gbo = (GlobalBusinessObject)((Object)bo);
        return gbo.isPersistable();
    }

    protected boolean isCorrectMaintenanceClass(MaintenanceDocument document, Class clazz) {
        if (document == null || clazz == null) {
            throw new IllegalArgumentException("Null arguments were passed in.");
        }
        return clazz.toString().equals(document.getNewMaintainableObject().getDataObjectClass().toString());
    }

    protected boolean checkEmptyBOField(String propertyName, Object valueToTest, String parameter) {
        boolean success = true;
        success = this.checkEmptyValue(valueToTest);
        if (!success) {
            this.putFieldError(propertyName, "error.required", parameter);
        }
        return success;
    }

    protected boolean checkEmptyDocumentField(String propertyName, Object valueToTest, String parameter) {
        boolean success = true;
        success = this.checkEmptyValue(valueToTest);
        if (!success) {
            this.putDocumentError(propertyName, "error.required", parameter);
        }
        return success;
    }

    protected boolean checkEmptyValue(Object valueToTest) {
        boolean success = true;
        if (valueToTest == null) {
            success = false;
        } else if (valueToTest instanceof String && StringUtils.isBlank((String)((String)valueToTest))) {
            success = false;
        }
        return success;
    }

    protected void showErrorMap() {
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            return;
        }
        for (Map.Entry<String, AutoPopulatingList<ErrorMessage>> e : GlobalVariables.getMessageMap().getAllPropertiesAndErrors()) {
            AutoPopulatingList<ErrorMessage> errorList = e.getValue();
            for (ErrorMessage em : errorList) {
                if (em.getMessageParameters() == null) {
                    LOG.error((Object)(e.getKey().toString() + " = " + em.getErrorKey()));
                    continue;
                }
                LOG.error((Object)(e.getKey().toString() + " = " + em.getErrorKey() + " : " + em.getMessageParameters().toString()));
            }
        }
    }

    @Override
    public void setupBaseConvenienceObjects(MaintenanceDocument document) {
        this.oldDataObject = document.getOldMaintainableObject().getDataObject();
        if (this.oldDataObject != null && this.oldDataObject instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)this.oldDataObject).refreshNonUpdateableReferences();
        }
        this.newDataObject = document.getNewMaintainableObject().getDataObject();
        if (this.newDataObject instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)this.newDataObject).refreshNonUpdateableReferences();
        }
        this.dataObjectClass = document.getNewMaintainableObject().getDataObjectClass();
        this.setupConvenienceObjects();
    }

    @Override
    public void setupConvenienceObjects() {
    }

    protected boolean checkForPartiallyFilledOutReferenceForeignKeys(String referenceName) {
        ForeignKeyFieldsPopulationState fkFieldsState;
        boolean success = true;
        if (this.newDataObject instanceof PersistableBusinessObject && (fkFieldsState = this.getPersistenceStructureService().getForeignKeyFieldsPopulationState((PersistableBusinessObject)this.newDataObject, referenceName)).isAnyFieldsPopulated() && !fkFieldsState.isAllFieldsPopulated()) {
            success = false;
            ArrayList fKeys = new ArrayList(this.getPersistenceStructureService().getForeignKeysForReference(this.newDataObject.getClass().asSubclass(PersistableBusinessObject.class), referenceName).keySet());
            String fKeysReadable = this.consolidateFieldNames(fKeys, ", ").toString();
            for (String fieldName : fkFieldsState.getUnpopulatedFieldNames()) {
                String fieldNameReadable = this.getDataDictionaryService().getAttributeLabel(this.newDataObject.getClass(), fieldName);
                this.putFieldError(fieldName, "error.document.maintenance.partiallyFilledOutReferenceForeignKeys", new String[]{fieldNameReadable, fKeysReadable});
            }
        }
        return success;
    }

    protected StringBuffer consolidateFieldNames(List fieldNames, String delimiter) {
        StringBuffer sb = new StringBuffer();
        boolean firstPass = true;
        String delim = "";
        for (String fieldName : fieldNames) {
            sb.append(delim + this.getDataDictionaryService().getAttributeLabel(this.newDataObject.getClass(), fieldName));
            if (!firstPass) continue;
            delim = delimiter;
            firstPass = false;
        }
        return sb;
    }

    protected String getFieldLabel(String fieldName) {
        return this.getDataDictionaryService().getAttributeLabel(this.newDataObject.getClass(), fieldName) + "(" + this.getDataDictionaryService().getAttributeShortLabel(this.newDataObject.getClass(), fieldName) + ")";
    }

    protected String getFieldLabel(Class dataObjectClass, String fieldName) {
        return this.getDataDictionaryService().getAttributeLabel(dataObjectClass, fieldName) + "(" + this.getDataDictionaryService().getAttributeShortLabel(dataObjectClass, fieldName) + ")";
    }

    protected final Object getNewDataObject() {
        return this.newDataObject;
    }

    protected void setNewDataObject(Object newDataObject) {
        this.newDataObject = newDataObject;
    }

    protected final Object getOldDataObject() {
        return this.oldDataObject;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        return true;
    }

    protected final BusinessObjectService getBoService() {
        if (this.boService == null) {
            this.boService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.boService;
    }

    public final void setBoService(BusinessObjectService boService) {
        this.boService = boService;
    }

    protected final ConfigurationService getConfigService() {
        if (this.configService == null) {
            this.configService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.configService;
    }

    public final void setConfigService(ConfigurationService configService) {
        this.configService = configService;
    }

    protected final DataDictionaryService getDdService() {
        if (this.ddService == null) {
            this.ddService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.ddService;
    }

    public final void setDdService(DataDictionaryService ddService) {
        this.ddService = ddService;
    }

    @Override
    protected final DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KRADServiceLocatorWeb.getDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    public final void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    @Override
    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DateTimeService getDateTimeService() {
        return CoreApiServiceLocator.getDateTimeService();
    }

    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    protected final PersistenceStructureService getPersistenceStructureService() {
        if (this.persistenceStructureService == null) {
            this.persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return this.persistenceStructureService;
    }

    public final void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        if (this.workflowDocumentService == null) {
            this.workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
        }
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }
}

