/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.exception.InvalidAddressException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.MailService;
import org.kuali.rice.core.api.mail.EmailBcList;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailCcList;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailToList;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;

public class MailServiceImpl
implements MailService {
    private static Logger LOG = Logger.getLogger(MailServiceImpl.class);
    private String batchMailingList;
    private Mailer mailer;
    private String nonProductionNotificationMailingList;
    private boolean realNotificationsEnabled = true;

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public void setBatchMailingList(String batchMailingList) {
        this.batchMailingList = batchMailingList;
    }

    @Override
    public String getBatchMailingList() {
        return this.batchMailingList;
    }

    @Override
    public void sendMessage(MailMessage message) throws InvalidAddressException, MessagingException {
        this.sendMessage(message, false);
    }

    @Override
    public void sendMessage(MailMessage message, boolean htmlMessage) throws InvalidAddressException, MessagingException {
        if (!htmlMessage) {
            this.mailer.sendEmail(this.composeMessage(message));
            return;
        }
        message = this.composeMessage(message, htmlMessage);
        ArrayList bccAddresses = new ArrayList();
        bccAddresses.addAll(message.getBccAddresses());
        ArrayList ccAddresses = new ArrayList();
        ccAddresses.addAll(message.getCcAddresses());
        ArrayList toAddresses = new ArrayList();
        toAddresses.addAll(message.getToAddresses());
        this.mailer.sendEmail(new EmailFrom(message.getFromAddress()), new EmailToList(toAddresses), new EmailSubject(message.getSubject()), new EmailBody(message.getMessage()), new EmailCcList(ccAddresses), new EmailBcList(bccAddresses), true);
    }

    protected MailMessage composeMessage(MailMessage message, boolean htmlMessage) {
        MailMessage mm = new MailMessage();
        if (!this.isRealNotificationsEnabled()) {
            this.getNonProductionMessage(message, htmlMessage);
        }
        String app = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.id");
        String env = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
        mm.setToAddresses(message.getToAddresses());
        mm.setBccAddresses(message.getBccAddresses());
        mm.setCcAddresses(message.getCcAddresses());
        mm.setSubject(app + " " + env + ": " + message.getSubject());
        mm.setMessage(message.getMessage());
        mm.setFromAddress(message.getFromAddress());
        return mm;
    }

    protected MailMessage composeMessage(MailMessage message) {
        return this.composeMessage(message, false);
    }

    public String getNonProductionNotificationMailingList() {
        return this.nonProductionNotificationMailingList;
    }

    public void setNonProductionNotificationMailingList(String nonProductionNotificationMailingList) {
        this.nonProductionNotificationMailingList = nonProductionNotificationMailingList;
    }

    public boolean isRealNotificationsEnabled() {
        return this.realNotificationsEnabled;
    }

    public void setRealNotificationsEnabled(boolean realNotificationsEnabled) {
        this.realNotificationsEnabled = realNotificationsEnabled;
    }

    protected MailMessage getNonProductionMessage(MailMessage message, boolean htmlMessage) {
        StringBuilder buf = new StringBuilder();
        String newLine = htmlMessage ? "<br/>" : "\n";
        buf.append("Email To: ").append(message.getToAddresses()).append(newLine);
        buf.append("Email CC: ").append(message.getCcAddresses()).append(newLine);
        buf.append("Email BCC: ").append(message.getBccAddresses()).append(newLine + newLine);
        buf.append(message.getMessage());
        message.setMessage(buf.toString());
        message.getToAddresses().clear();
        message.addToAddress(this.getNonProductionNotificationMailingList());
        message.getBccAddresses().clear();
        message.getCcAddresses().clear();
        return message;
    }
}

