/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.MaintainableXMLConversionService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.FileSystemResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MaintainableXMLConversionServiceImpl
implements MaintainableXMLConversionService,
ApplicationContextAware,
InitializingBean {
    private static Logger LOG = Logger.getLogger(MaintainableXMLConversionServiceImpl.class);
    protected static final String SERIALIZATION_ATTRIBUTE = "serialization";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final String DEFINED_IN_ATTRIBUTE = "defined-in";
    protected static final String MAINTENANCE_ACTION_ELEMENT_NAME = "maintenanceAction";
    protected Map<String, String> classNameRuleMap;
    protected Map<String, Map<String, String>> classPropertyRuleMap;
    protected Set<String> classRemovals;
    protected Map<String, Set<String>> classPropertyRemovals;
    protected List<String> conversionRuleFiles;
    protected ApplicationContext applicationContext;
    protected volatile KualiModuleService kualiModuleService;
    protected volatile PersistenceStructureService persistenceStructureService;

    @Override
    public String transformMaintainableXML(String xml) {
        String maintenanceAction = "<maintenanceAction>" + StringUtils.substringAfter((String)xml, (String)"<maintenanceAction>");
        xml = StringUtils.substringBefore((String)xml, (String)"<maintenanceAction>");
        if (!CollectionUtils.isEmpty(this.getConversionRuleFiles())) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(new InputSource(new StringReader(xml)));
                Node childNode = document.getFirstChild();
                while (childNode != null) {
                    Node nextChild = childNode.getNextSibling();
                    this.transformClassNode(document, childNode);
                    childNode = nextChild;
                }
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer trans = transFactory.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.setOutputProperty("indent", "yes");
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                DOMSource source = new DOMSource(document);
                trans.transform(source, result);
                xml = writer.toString().replaceAll("(?m)^\\s+\\n", "");
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return xml + maintenanceAction;
    }

    public List<String> getConversionRuleFiles() {
        return this.conversionRuleFiles;
    }

    public void setConversionRuleFiles(List<String> conversionRuleFiles) {
        this.conversionRuleFiles = conversionRuleFiles;
    }

    protected void transformClassNode(Document document, Node node) throws ClassNotFoundException, XPathExpressionException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        String className = node.getNodeName();
        if (this.classNameRuleMap.containsKey(className)) {
            String newClassName = this.classNameRuleMap.get(className);
            document.renameNode(node, null, newClassName);
            className = newClassName;
        } else {
            if (this.classRemovals.contains(className)) {
                node.getParentNode().removeChild(node);
                return;
            }
            if (!className.contains(".")) {
                return;
            }
        }
        Class<?> dataObjectClass = Class.forName(className);
        if (this.classPropertyRuleMap.containsKey(className)) {
            this.transformNode(document, node, dataObjectClass, this.classPropertyRuleMap.get(className));
        }
        this.transformNode(document, node, dataObjectClass, this.classPropertyRuleMap.get("*"));
    }

    protected void transformNode(Document document, Node node, Class<?> currentClass, Map<String, String> propertyMappings) throws ClassNotFoundException, XPathExpressionException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (currentClass != null && this.classRemovals.contains(currentClass.getName())) {
            node.getParentNode().removeChild(node);
            return;
        }
        Node childNode = node.getFirstChild();
        while (childNode != null) {
            Node nextChild = childNode.getNextSibling();
            String propertyName = childNode.getNodeName();
            if (childNode.hasAttributes()) {
                Node classAttribute;
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node serializationAttribute = childNode.getAttributes().getNamedItem(SERIALIZATION_ATTRIBUTE);
                if (serializationAttribute != null && StringUtils.equals((String)serializationAttribute.getNodeValue(), (String)"custom")) {
                    Node nextRemoveNode;
                    Object removeNode;
                    ArrayList<Node> nodesToAdd;
                    classAttribute = childNode.getAttributes().getNamedItem(CLASS_ATTRIBUTE);
                    if (classAttribute != null) {
                        if (StringUtils.equals((String)classAttribute.getNodeValue(), (String)"org.kuali.rice.kns.util.TypedArrayList")) {
                            ((Element)childNode).removeAttribute(SERIALIZATION_ATTRIBUTE);
                            ((Element)childNode).removeAttribute(CLASS_ATTRIBUTE);
                            XPathExpression listSizeExpression = xpath.compile("//" + propertyName + "/org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl/default/size/text()");
                            String size = (String)listSizeExpression.evaluate(childNode, XPathConstants.STRING);
                            nodesToAdd = new ArrayList();
                            if (StringUtils.isNotBlank((String)size) && Integer.valueOf(size) > 0) {
                                XPathExpression listTypeExpression = xpath.compile("//" + propertyName + "/org.kuali.rice.kns.util.TypedArrayList/default/listObjectType/text()");
                                String listType = (String)listTypeExpression.evaluate(childNode, XPathConstants.STRING);
                                XPathExpression listContentsExpression = xpath.compile("//" + propertyName + "/org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl/" + listType);
                                NodeList listContents = (NodeList)listContentsExpression.evaluate(childNode, XPathConstants.NODESET);
                                for (int i = 0; i < listContents.getLength(); ++i) {
                                    Node tempNode = listContents.item(i);
                                    this.transformClassNode(document, tempNode);
                                    nodesToAdd.add(tempNode);
                                }
                            }
                            removeNode = childNode.getFirstChild();
                            while (removeNode != null) {
                                nextRemoveNode = removeNode.getNextSibling();
                                childNode.removeChild((Node)removeNode);
                                removeNode = nextRemoveNode;
                            }
                            for (Node nodeToAdd : nodesToAdd) {
                                childNode.appendChild(nodeToAdd);
                            }
                        }
                    } else {
                        ((Element)childNode).removeAttribute(SERIALIZATION_ATTRIBUTE);
                        XPathExpression mapContentsExpression = xpath.compile("//" + propertyName + "/map/string");
                        NodeList mapContents = (NodeList)mapContentsExpression.evaluate(childNode, XPathConstants.NODESET);
                        nodesToAdd = new ArrayList<Node>();
                        if (mapContents.getLength() > 0 && mapContents.getLength() % 2 == 0) {
                            for (int i = 0; i < mapContents.getLength(); ++i) {
                                Node keyNode = mapContents.item(i);
                                Node valueNode = mapContents.item(++i);
                                Element entryNode = document.createElement("entry");
                                entryNode.appendChild(keyNode);
                                entryNode.appendChild(valueNode);
                                nodesToAdd.add(entryNode);
                            }
                        }
                        removeNode = childNode.getFirstChild();
                        while (removeNode != null) {
                            nextRemoveNode = removeNode.getNextSibling();
                            childNode.removeChild((Node)removeNode);
                            removeNode = nextRemoveNode;
                        }
                        for (Node nodeToAdd : nodesToAdd) {
                            childNode.appendChild(nodeToAdd);
                        }
                    }
                } else {
                    classAttribute = childNode.getAttributes().getNamedItem(CLASS_ATTRIBUTE);
                    if (classAttribute != null) {
                        if (this.classRemovals.contains(classAttribute.getNodeValue())) {
                            childNode.getParentNode().removeChild(childNode);
                            childNode = null;
                        } else if (this.classNameRuleMap.containsKey(classAttribute.getNodeValue())) {
                            classAttribute.setNodeValue(this.classNameRuleMap.get(classAttribute.getNodeValue()));
                        }
                    } else {
                        Node definedInAttribute = childNode.getAttributes().getNamedItem(DEFINED_IN_ATTRIBUTE);
                        if (definedInAttribute != null) {
                            if (this.classRemovals.contains(definedInAttribute.getNodeValue())) {
                                childNode.getParentNode().removeChild(childNode);
                                childNode = null;
                            } else if (this.classNameRuleMap.containsKey(definedInAttribute.getNodeValue())) {
                                definedInAttribute.setNodeValue(this.classNameRuleMap.get(definedInAttribute.getNodeValue()));
                            }
                        }
                    }
                }
            }
            if (childNode != null && propertyMappings != null && propertyMappings.containsKey(propertyName)) {
                String newPropertyName = propertyMappings.get(propertyName);
                if (StringUtils.isNotBlank((String)newPropertyName)) {
                    document.renameNode(childNode, null, newPropertyName);
                    propertyName = newPropertyName;
                } else {
                    node.removeChild(childNode);
                    childNode = nextChild;
                    continue;
                }
            }
            if (childNode != null && childNode.hasChildNodes()) {
                if (!Collection.class.isAssignableFrom(currentClass) && !Map.class.isAssignableFrom(currentClass)) {
                    try {
                        Node firstChild;
                        String value;
                        Map<String, DataObjectRelationship> relationshipMetadata;
                        Class<?> propertyClass = this.convertToExternalizableBusinessObjectImplementationIfNecessary(PropertyUtils.getPropertyType(currentClass.newInstance(), (String)propertyName));
                        if (propertyName.equals("extension") && (relationshipMetadata = this.getPersistenceStructureService().getRelationshipMetadata(currentClass, "extension")).containsKey("extension")) {
                            propertyClass = relationshipMetadata.get("extension").getRelatedClass();
                        }
                        if (propertyClass != null && this.classPropertyRuleMap.containsKey(propertyClass.getName())) {
                            this.transformNode(document, childNode, propertyClass, this.classPropertyRuleMap.get(propertyClass.getName()));
                        }
                        if ((propertyClass == Timestamp.class || propertyClass == Date.class) && (value = (firstChild = childNode.getFirstChild()).getNodeValue()) != null && value.length() == 10) {
                            firstChild.setNodeValue(value + " 00:00:00" + (propertyClass == Date.class ? "AM" : ""));
                        }
                        this.transformNode(document, childNode, propertyClass, this.classPropertyRuleMap.get("*"));
                    }
                    catch (InstantiationException | NoSuchMethodException e) {
                        LOG.warn((Object)("Could not instantiate an instance of " + currentClass.getName() + " and therefore, not transforming children"));
                    }
                } else if (Collection.class.isAssignableFrom(currentClass)) {
                    this.transformClassNode(document, childNode);
                }
            }
            childNode = nextChild;
        }
    }

    protected void setRuleMaps() {
        this.setupConfigurationMaps();
        try {
            for (String conversionRuleFile : this.getConversionRuleFiles()) {
                this.loadConversionRuleFile(conversionRuleFile);
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void loadConversionRuleFile(String conversionRuleFile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Object resource = null;
        Document doc = null;
        resource = StringUtils.startsWith((String)conversionRuleFile, (String)"classpath") ? this.getApplicationContext().getResource(conversionRuleFile) : new FileSystemResource(conversionRuleFile);
        doc = !resource.exists() ? db.parse(this.getClass().getResourceAsStream(conversionRuleFile)) : db.parse(resource.getInputStream());
        doc.getDocumentElement().normalize();
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression exprClassNames = xpath.compile("//*[@name='maint_doc_classname_changes']/pattern");
        NodeList classNamesList = (NodeList)exprClassNames.evaluate(doc, XPathConstants.NODESET);
        for (int s = 0; s < classNamesList.getLength(); ++s) {
            String matchText = xpath.evaluate("match/text()", classNamesList.item(s));
            String replaceText = xpath.evaluate("replacement/text()", classNamesList.item(s));
            this.classNameRuleMap.put(matchText, replaceText);
        }
        XPathExpression exprClassProperties = xpath.compile("//*[@name='maint_doc_changed_class_properties']/pattern");
        XPathExpression exprClassPropertiesPatterns = xpath.compile("pattern");
        NodeList propertyClassList = (NodeList)exprClassProperties.evaluate(doc, XPathConstants.NODESET);
        for (int s = 0; s < propertyClassList.getLength(); ++s) {
            String classText = xpath.evaluate("class/text()", propertyClassList.item(s));
            HashMap<String, String> propertyRuleMap = new HashMap<String, String>();
            NodeList classPropertiesPatterns = (NodeList)exprClassPropertiesPatterns.evaluate(propertyClassList.item(s), XPathConstants.NODESET);
            for (int c = 0; c < classPropertiesPatterns.getLength(); ++c) {
                String matchText = xpath.evaluate("match/text()", classPropertiesPatterns.item(c));
                String replaceText = xpath.evaluate("replacement/text()", classPropertiesPatterns.item(c));
                propertyRuleMap.put(matchText, replaceText);
            }
            this.classPropertyRuleMap.put(classText, propertyRuleMap);
        }
        XPathExpression exprClassRemovals = xpath.compile("//*[@name='maint_doc_classname_removals']/pattern");
        NodeList classRemovalList = (NodeList)exprClassRemovals.evaluate(doc, XPathConstants.NODESET);
        for (int s = 0; s < classRemovalList.getLength(); ++s) {
            String matchText = xpath.evaluate("match/text()", classRemovalList.item(s));
            this.classRemovals.add(matchText);
        }
    }

    protected void setupConfigurationMaps() {
        this.classNameRuleMap = new HashMap<String, String>();
        this.classPropertyRuleMap = new HashMap<String, Map<String, String>>();
        this.classRemovals = new HashSet<String>();
        HashMap<String, String> defaultPropertyRules = new HashMap<String, String>();
        defaultPropertyRules.put("boNotes", "");
        defaultPropertyRules.put("autoIncrementSet", "");
        this.classPropertyRuleMap.put("*", defaultPropertyRules);
    }

    protected Class<?> convertToExternalizableBusinessObjectImplementationIfNecessary(Class<?> currentClass) {
        if (currentClass != null && currentClass.isInterface() && ExternalizableBusinessObject.class.isAssignableFrom(currentClass)) {
            ModuleService eboOwningModule = this.getKualiModuleService().getResponsibleModuleService(currentClass);
            return eboOwningModule.getExternalizableBusinessObjectImplementation(currentClass);
        }
        return currentClass;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.setRuleMaps();
    }

    public KualiModuleService getKualiModuleService() {
        if (this.kualiModuleService == null) {
            this.kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return this.kualiModuleService;
    }

    public PersistenceStructureService getPersistenceStructureService() {
        if (this.persistenceStructureService == null) {
            this.persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return this.persistenceStructureService;
    }
}

