/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.NoteDao;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class NoteServiceImpl
implements NoteService {
    private NoteDao noteDao;
    private AttachmentService attachmentService;

    @Override
    public void saveNoteList(List<Note> notes) {
        if (notes != null) {
            for (Note note : notes) {
                if (StringUtils.isBlank((String)note.getRemoteObjectIdentifier())) {
                    throw new IllegalStateException("The remote object identifier must be established on a Note before it can be saved.  The following note in the given list had a null or empty remote object identifier: " + note);
                }
                this.save(note);
            }
        }
    }

    @Override
    public Note save(Note note) {
        this.validateNoteNotNull(note);
        if (StringUtils.isBlank((String)note.getRemoteObjectIdentifier())) {
            throw new IllegalStateException("The remote object identifier must be established on a Note before it can be saved.  Given note had a null or empty remote object identifier.");
        }
        this.noteDao.save(note);
        if (note.getAttachment() != null) {
            this.attachmentService.moveAttachmentWherePending(note);
        }
        return note;
    }

    @Override
    public List<Note> getByRemoteObjectId(String remoteObjectId) {
        if (StringUtils.isBlank((String)remoteObjectId)) {
            throw new IllegalArgumentException("The remoteObjectId must not be null or blank.");
        }
        return this.noteDao.findByremoteObjectId(remoteObjectId);
    }

    @Override
    public Note getNoteByNoteId(Long noteId) {
        if (noteId == null) {
            throw new IllegalArgumentException("The noteId must not be null.");
        }
        return this.noteDao.getNoteByNoteId(noteId);
    }

    @Override
    public void deleteNote(Note note) {
        this.validateNoteNotNull(note);
        this.noteDao.deleteNote(note);
    }

    @Override
    public Note createNote(Note noteToCopy, PersistableBusinessObject bo, String authorPrincipalId) {
        this.validateNoteNotNull(noteToCopy);
        if (bo == null) {
            throw new IllegalArgumentException("The bo must not be null.");
        }
        if (StringUtils.isBlank((String)authorPrincipalId)) {
            throw new IllegalArgumentException("The authorPrincipalId must not be null.");
        }
        Note tmpNote = (Note)((Object)ObjectUtils.deepCopy((Serializable)((Object)noteToCopy)));
        tmpNote.setRemoteObjectIdentifier(bo.getObjectId());
        tmpNote.setAuthorUniversalIdentifier(authorPrincipalId);
        return tmpNote;
    }

    public void setNoteDao(NoteDao d) {
        this.noteDao = d;
    }

    protected NoteDao getNoteDao() {
        return this.noteDao;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    protected AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    private void validateNoteNotNull(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note must not be null.");
        }
    }
}

