/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.control;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.MethodInvokerConfig;
import org.kuali.kfs.krad.uif.control.TextControl;
import org.kuali.kfs.krad.uif.field.AttributeQuery;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.QuickFinder;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class UserControl
extends TextControl {
    private static final long serialVersionUID = 7468340793076585869L;
    private String principalIdPropertyName;
    private String personNamePropertyName;
    private String personObjectPropertyName;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (!(parent instanceof InputField)) {
            return;
        }
        InputField field = (InputField)parent;
        field.getHiddenPropertyNames().add(this.principalIdPropertyName);
        if (!field.isReadOnly()) {
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                field.getInformationalDisplayPropertyNames().add(this.personNamePropertyName);
            } else {
                field.getInformationalDisplayPropertyNames().add(this.personObjectPropertyName + ".name");
            }
            String idPropertyPath = field.getBindingInfo().getPropertyAdjustedBindingPath(this.principalIdPropertyName);
            String onChangeScript = "setValue('" + idPropertyPath + "','');";
            if (StringUtils.isNotBlank((String)field.getOnChangeScript())) {
                onChangeScript = field.getOnChangeScript() + onChangeScript;
            }
            field.setOnChangeScript(onChangeScript);
        }
        if (field.isReadOnly() && StringUtils.isBlank((String)field.getAdditionalDisplayPropertyName())) {
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                field.setAdditionalDisplayPropertyName(this.personNamePropertyName);
            } else {
                field.setAdditionalDisplayPropertyName(this.personObjectPropertyName + ".name");
            }
        }
        AttributeQuery attributeQuery = new AttributeQuery();
        MethodInvokerConfig methodInvokerConfig = new MethodInvokerConfig();
        PersonService personService = KimApiServiceLocator.getPersonService();
        methodInvokerConfig.setTargetObject(personService);
        attributeQuery.setQueryMethodInvokerConfig(methodInvokerConfig);
        attributeQuery.setQueryMethodToCall("getPersonByPrincipalName");
        attributeQuery.getQueryMethodArgumentFieldList().add(field.getPropertyName());
        attributeQuery.getReturnFieldMapping().put("principalId", this.principalIdPropertyName);
        if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
            attributeQuery.getReturnFieldMapping().put("name", this.personNamePropertyName);
        } else {
            attributeQuery.getReturnFieldMapping().put("name", this.personObjectPropertyName + ".name");
        }
        field.setFieldAttributeQuery(attributeQuery);
        QuickFinder quickFinder = field.getFieldLookup();
        if (quickFinder.isRender()) {
            if (StringUtils.isBlank((String)quickFinder.getDataObjectClassName())) {
                quickFinder.setDataObjectClassName(Person.class.getName());
            }
            if (quickFinder.getFieldConversions().isEmpty()) {
                quickFinder.getFieldConversions().put("principalId", this.principalIdPropertyName);
                if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                    quickFinder.getFieldConversions().put("name", this.personNamePropertyName);
                } else {
                    quickFinder.getFieldConversions().put("name", this.personObjectPropertyName + ".name");
                }
                quickFinder.getFieldConversions().put("principalName", field.getPropertyName());
            }
        }
    }

    public String getPrincipalIdPropertyName() {
        return this.principalIdPropertyName;
    }

    public void setPrincipalIdPropertyName(String principalIdPropertyName) {
        this.principalIdPropertyName = principalIdPropertyName;
    }

    public String getPersonNamePropertyName() {
        return this.personNamePropertyName;
    }

    public void setPersonNamePropertyName(String personNamePropertyName) {
        this.personNamePropertyName = personNamePropertyName;
    }

    public String getPersonObjectPropertyName() {
        return this.personObjectPropertyName;
    }

    public void setPersonObjectPropertyName(String personObjectPropertyName) {
        this.personObjectPropertyName = personObjectPropertyName;
    }
}

