/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ConfigurableBase;
import org.kuali.kfs.krad.uif.component.PropertyReplacer;
import org.kuali.kfs.krad.uif.component.ReferenceCopy;
import org.kuali.kfs.krad.uif.container.Container;
import org.kuali.kfs.krad.uif.layout.LayoutManager;
import org.kuali.kfs.krad.uif.view.View;

public abstract class LayoutManagerBase
extends ConfigurableBase
implements LayoutManager {
    private static final long serialVersionUID = -2657663560459456814L;
    private String id;
    private String template;
    private String style;
    private List<String> styleClasses = new ArrayList<String>();
    @ReferenceCopy(newCollectionInstance=true)
    private Map<String, Object> context = new HashMap<String, Object>();
    private List<PropertyReplacer> propertyReplacers = new ArrayList<PropertyReplacer>();

    @Override
    public void performInitialization(View view, Object model, Container container) {
        if (StringUtils.isBlank((String)this.id)) {
            this.id = container.getId() + "_layout";
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Container container) {
    }

    @Override
    public void performFinalize(View view, Object model, Container container) {
    }

    @Override
    public Set<String> getPropertiesForReferenceCopy() {
        HashSet<String> refCopyProperties = new HashSet<String>();
        refCopyProperties.add("context");
        return refCopyProperties;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return Container.class;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        return new ArrayList<Component>();
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        return components;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public List<String> getStyleClasses() {
        return this.styleClasses;
    }

    @Override
    public void setStyleClasses(List<String> styleClasses) {
        this.styleClasses = styleClasses;
    }

    public String getStyleClassesAsString() {
        if (this.styleClasses != null) {
            return StringUtils.join(this.styleClasses, (String)" ");
        }
        return "";
    }

    public void setStyleClasses(String styleClasses) {
        String[] classes = StringUtils.split((String)styleClasses);
        this.styleClasses = Arrays.asList(classes);
    }

    @Override
    public void addStyleClass(String styleClass) {
        if (!this.styleClasses.contains(styleClass)) {
            this.styleClasses.add(styleClass);
        }
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public void pushObjectToContext(String objectName, Object object) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.context.put(objectName, object);
    }

    @Override
    public List<PropertyReplacer> getPropertyReplacers() {
        return this.propertyReplacers;
    }

    @Override
    public void setPropertyReplacers(List<PropertyReplacer> propertyReplacers) {
        this.propertyReplacers = propertyReplacers;
    }
}

