/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.Configurable;
import org.kuali.kfs.krad.uif.component.KeepExpression;
import org.kuali.kfs.krad.uif.component.PropertyReplacer;
import org.kuali.kfs.krad.uif.layout.LayoutManager;
import org.kuali.kfs.krad.uif.service.ExpressionEvaluatorService;
import org.kuali.kfs.krad.uif.util.CloneUtils;
import org.kuali.kfs.krad.uif.util.ExpressionFunctions;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionEvaluatorServiceImpl
implements ExpressionEvaluatorService {
    private static final Logger LOG = Logger.getLogger(ExpressionEvaluatorServiceImpl.class);

    @Override
    public void evaluateObjectExpressions(Object object, Object contextObject, Map<String, Object> evaluationParameters) {
        if (object instanceof Component || object instanceof LayoutManager) {
            this.evaluatePropertyReplacers(object, contextObject, evaluationParameters);
        }
        this.evaluatePropertyExpressions(object, contextObject, evaluationParameters);
    }

    @Override
    public String evaluateExpressionTemplate(Object contextObject, Map<String, Object> evaluationParameters, String expressionTemplate) {
        StandardEvaluationContext context = new StandardEvaluationContext(contextObject);
        context.setVariables(evaluationParameters);
        this.addCustomFunctions(context);
        SpelExpressionParser parser = new SpelExpressionParser();
        String result = null;
        try {
            Expression expression = null;
            expression = StringUtils.contains((String)expressionTemplate, (String)"@{") ? parser.parseExpression(expressionTemplate, (ParserContext)new TemplateParserContext("@{", "}")) : parser.parseExpression(expressionTemplate);
            result = (String)expression.getValue((EvaluationContext)context, String.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception evaluating expression: " + expressionTemplate));
            throw new RuntimeException("Exception evaluating expression: " + expressionTemplate, e);
        }
        return result;
    }

    @Override
    public Object evaluateExpression(Object contextObject, Map<String, Object> evaluationParameters, String expressionStr) {
        StandardEvaluationContext context = new StandardEvaluationContext(contextObject);
        context.setVariables(evaluationParameters);
        this.addCustomFunctions(context);
        if (StringUtils.startsWith((String)expressionStr, (String)"@{") && StringUtils.endsWith((String)expressionStr, (String)"}")) {
            expressionStr = StringUtils.removeStart((String)expressionStr, (String)"@{");
            expressionStr = StringUtils.removeEnd((String)expressionStr, (String)"}");
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Object result = null;
        try {
            Expression expression = parser.parseExpression(expressionStr);
            result = expression.getValue((EvaluationContext)context);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception evaluating expression: " + expressionStr));
            throw new RuntimeException("Exception evaluating expression: " + expressionStr, e);
        }
        return result;
    }

    protected void addCustomFunctions(StandardEvaluationContext context) {
        try {
            context.registerFunction("isAssignableFrom", ExpressionFunctions.class.getDeclaredMethod("isAssignableFrom", Class.class, Class.class));
            context.registerFunction("empty", ExpressionFunctions.class.getDeclaredMethod("empty", Object.class));
            context.registerFunction("getName", ExpressionFunctions.class.getDeclaredMethod("getName", Class.class));
            context.registerFunction("getParm", ExpressionFunctions.class.getDeclaredMethod("getParm", String.class, String.class, String.class));
            context.registerFunction("getParmInd", ExpressionFunctions.class.getDeclaredMethod("getParmInd", String.class, String.class, String.class));
            context.registerFunction("hasPerm", ExpressionFunctions.class.getDeclaredMethod("hasPerm", String.class, String.class));
            context.registerFunction("hasPermDtls", ExpressionFunctions.class.getDeclaredMethod("hasPermDtls", String.class, String.class, Map.class, Map.class));
            context.registerFunction("hasPermTmpl", ExpressionFunctions.class.getDeclaredMethod("hasPermTmpl", String.class, String.class, Map.class, Map.class));
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Custom function for el expressions not found: " + e.getMessage()));
            throw new RuntimeException("Custom function for el expressions not found: " + e.getMessage(), e);
        }
    }

    protected void evaluatePropertyReplacers(Object object, Object contextObject, Map<String, Object> evaluationParameters) {
        List<PropertyReplacer> replacers = null;
        if (Component.class.isAssignableFrom(object.getClass())) {
            replacers = ((Component)object).getPropertyReplacers();
        } else if (LayoutManager.class.isAssignableFrom(object.getClass())) {
            replacers = ((LayoutManager)object).getPropertyReplacers();
        }
        for (PropertyReplacer propertyReplacer : replacers) {
            String conditionEvaluation = this.evaluateExpressionTemplate(contextObject, evaluationParameters, propertyReplacer.getCondition());
            boolean conditionSuccess = Boolean.parseBoolean(conditionEvaluation);
            if (!conditionSuccess) continue;
            ObjectPropertyUtils.setPropertyValue(object, propertyReplacer.getPropertyName(), propertyReplacer.getReplacement());
        }
    }

    protected void evaluatePropertyExpressions(Object object, Object contextObject, Map<String, Object> evaluationParameters) {
        Map<Object, Object> propertyExpressions = new HashMap();
        if (Configurable.class.isAssignableFrom(object.getClass())) {
            propertyExpressions = ((Configurable)object).getPropertyExpressions();
        }
        for (Map.Entry propertyExpression : propertyExpressions.entrySet()) {
            String propertyName = (String)propertyExpression.getKey();
            String expression = (String)propertyExpression.getValue();
            if (CloneUtils.fieldHasAnnotation(object.getClass(), propertyName, KeepExpression.class)) {
                ObjectPropertyUtils.setPropertyValue(object, propertyName, expression);
                continue;
            }
            Object propertyValue = null;
            propertyValue = StringUtils.startsWith((String)expression, (String)"@{") && StringUtils.endsWith((String)expression, (String)"}") && StringUtils.countMatches((String)expression, (String)"@{") == 1 ? this.evaluateExpression(contextObject, evaluationParameters, expression) : this.evaluateExpressionTemplate(contextObject, evaluationParameters, expression);
            ObjectPropertyUtils.setPropertyValue(object, propertyName, propertyValue);
        }
    }

    @Override
    public boolean containsElPlaceholder(String value) {
        String elPlaceholder;
        boolean containsElPlaceholder = false;
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)(elPlaceholder = StringUtils.substringBetween((String)value, (String)"@{", (String)"}")))) {
            containsElPlaceholder = true;
        }
        return containsElPlaceholder;
    }
}

