/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.view;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.RequestParameter;
import org.kuali.kfs.krad.uif.view.DocumentView;
import org.kuali.kfs.krad.uif.view.View;

public class MaintenanceView
extends DocumentView {
    private static final long serialVersionUID = -3382802967703882341L;
    private static final Logger LOG = Logger.getLogger(MaintenanceView.class);
    private Class<?> dataObjectClassName;
    private String oldObjectBindingPath;
    @RequestParameter
    private String maintenanceAction;

    public MaintenanceView() {
        this.setViewTypeName(UifConstants.ViewType.MAINTENANCE);
    }

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        this.getAbstractTypeClasses().put(this.getDefaultBindingObjectPath(), this.getDataObjectClassName());
        this.getAbstractTypeClasses().put(this.getOldObjectBindingPath(), this.getDataObjectClassName());
    }

    @Override
    protected MaintenanceDocumentEntry getDocumentEntryForView() {
        MaintenanceDocumentEntry documentEntry = null;
        String docTypeName = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.getDataObjectClassName());
        if (StringUtils.isNotBlank((String)docTypeName)) {
            documentEntry = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentEntry(docTypeName);
        }
        if (documentEntry == null) {
            throw new RuntimeException("Unable to find maintenance document entry for data object class: " + this.getDataObjectClassName().getName());
        }
        return documentEntry;
    }

    public Class<?> getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(Class<?> dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public String getOldObjectBindingPath() {
        return this.oldObjectBindingPath;
    }

    public void setOldObjectBindingPath(String oldObjectBindingPath) {
        this.oldObjectBindingPath = oldObjectBindingPath;
    }

    public String getMaintenanceAction() {
        return this.maintenanceAction;
    }

    public void setMaintenanceAction(String maintenanceAction) {
        this.maintenanceAction = maintenanceAction;
    }
}

