/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.uif.util.UifFormManager;
import org.kuali.kfs.krad.uif.util.UifWebUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UifControllerHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = Logger.getLogger(UifControllerHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        UserSession session = KRADUtils.getUserSessionFromRequest(request);
        if (session == null) {
            throw new IllegalStateException("the user session has not been established");
        }
        GlobalVariables.setUserSession(session);
        GlobalVariables.clear();
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        UifWebUtils.postControllerHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        UifFormBase uifForm = uifFormManager.getCurrentForm();
        if (uifForm != null) {
            if (uifForm.isSkipViewInit()) {
                View postedView = uifForm.getPostedView();
                if (postedView != null) {
                    postedView.getViewHelperService().cleanViewAfterRender(postedView);
                }
            } else {
                View view = uifForm.getView();
                if (view != null) {
                    view.getViewHelperService().cleanViewAfterRender(view);
                }
                uifForm.setPostedView(view);
                uifForm.setView(null);
            }
        }
    }
}

