/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.core.framework.persistence.ojb.conversion;

import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class OjbCharBooleanConversion
implements FieldConversion {
    public static final String DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION = "Y";
    public static final String DATABASE_BOOLEAN_FALSE_STRING_REPRESENTATION = "N";

    public Object javaToSql(Object source) {
        if (source instanceof Boolean) {
            if (source != null) {
                Boolean b = (Boolean)source;
                return b != false ? DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION : DATABASE_BOOLEAN_FALSE_STRING_REPRESENTATION;
            }
            return null;
        }
        if (source instanceof String) {
            if ("true".equalsIgnoreCase((String)source) || "yes".equalsIgnoreCase((String)source) || "y".equalsIgnoreCase((String)source)) {
                return DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION;
            }
            if ("false".equalsIgnoreCase((String)source) || "no".equalsIgnoreCase((String)source) || "n".equalsIgnoreCase((String)source)) {
                return DATABASE_BOOLEAN_FALSE_STRING_REPRESENTATION;
            }
        }
        return source;
    }

    public Object sqlToJava(Object source) {
        try {
            if (source instanceof String) {
                if (source != null) {
                    String s = (String)source;
                    String trueValues = "YT1";
                    return trueValues.contains(s);
                }
                return null;
            }
            return source;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("I have exploded converting types", t);
        }
    }
}

