/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.namespace;

import groovy.transform.EqualsAndHashCode;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.kuali.kfs.coreservice.api.namespace.Namespace;
import org.kuali.kfs.coreservice.framework.namespace.NamespaceEbo;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KRCR_NMSPC_T")
@EqualsAndHashCode
public class NamespaceBo
extends PersistableBusinessObjectBase
implements NamespaceEbo {
    private static final long serialVersionUID = 1L;
    @Column(name="APPL_ID")
    private String applicationId;
    @Id
    @Column(name="NMSPC_CD")
    private String code;
    @Column(name="NM")
    private String name;
    @Column(name="ACTV_IND")
    private boolean active = true;

    public static Namespace to(NamespaceBo bo) {
        if (bo == null) {
            return null;
        }
        return Namespace.Builder.create(bo).build();
    }

    public static NamespaceBo from(Namespace im) {
        if (im == null) {
            return null;
        }
        NamespaceBo bo = new NamespaceBo();
        bo.setApplicationId(im.getApplicationId());
        bo.setActive(im.isActive());
        bo.setCode(im.getCode());
        bo.setName(im.getName());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

