/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterKey;
import org.kuali.kfs.coreservice.api.parameter.ParameterQueryResults;
import org.kuali.kfs.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.kfs.coreservice.impl.parameter.ParameterBo;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.util.Truth;

public final class ParameterRepositoryServiceImpl
implements ParameterRepositoryService {
    private static final String SUB_PARAM_SEPARATOR = "=";
    private BusinessObjectService businessObjectService;
    private CriteriaLookupService criteriaLookupService;

    @Override
    public Parameter createParameter(Parameter parameter) {
        if (parameter == null) {
            throw new RiceIllegalArgumentException("parameter is null");
        }
        ParameterKey key = ParameterKey.create(parameter.getApplicationId(), parameter.getNamespaceCode(), parameter.getComponentCode(), parameter.getName());
        Parameter existing = this.getParameter(key);
        if (existing != null && existing.getApplicationId().equals(parameter.getApplicationId())) {
            throw new RiceIllegalStateException("the parameter to create already exists: " + parameter);
        }
        return ParameterBo.to(this.businessObjectService.save(ParameterBo.from(parameter)));
    }

    @Override
    public Parameter updateParameter(Parameter parameter) {
        Parameter toUpdate;
        if (parameter == null) {
            throw new RiceIllegalArgumentException("parameter is null");
        }
        ParameterKey key = ParameterKey.create(parameter.getApplicationId(), parameter.getNamespaceCode(), parameter.getComponentCode(), parameter.getName());
        Parameter existing = this.getParameter(key);
        if (existing == null) {
            throw new RiceIllegalStateException("the parameter does not exist: " + parameter);
        }
        if (!existing.getApplicationId().equals(parameter.getApplicationId())) {
            Parameter.Builder builder = Parameter.Builder.create(parameter);
            builder.setApplicationId(existing.getApplicationId());
            toUpdate = builder.build();
        } else {
            toUpdate = parameter;
        }
        return ParameterBo.to(this.businessObjectService.save(ParameterBo.from(toUpdate)));
    }

    @Override
    public Parameter getParameter(ParameterKey key) {
        return ParameterBo.to(this.getParameterBo(key));
    }

    private ParameterBo getParameterBo(ParameterKey key) {
        if (key == null) {
            throw new RiceIllegalArgumentException("key is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", key.getName());
        map.put("applicationId", key.getApplicationId());
        map.put("namespaceCode", key.getNamespaceCode());
        map.put("componentCode", key.getComponentCode());
        ParameterBo bo = this.businessObjectService.findByPrimaryKey(ParameterBo.class, Collections.unmodifiableMap(map));
        if (bo == null & !"KUALI".equals(key.getApplicationId())) {
            map.put("applicationId", "KUALI");
            bo = this.businessObjectService.findByPrimaryKey(ParameterBo.class, Collections.unmodifiableMap(map));
        }
        return bo;
    }

    @Override
    public String getParameterValueAsString(ParameterKey key) {
        ParameterBo p = this.getParameterBo(key);
        return p != null ? p.getValue() : null;
    }

    @Override
    public Boolean getParameterValueAsBoolean(ParameterKey key) {
        ParameterBo p = this.getParameterBo(key);
        String value = p != null ? p.getValue() : null;
        return Truth.strToBooleanIgnoreCase((String)value);
    }

    @Override
    public Collection<String> getParameterValuesAsString(ParameterKey key) {
        return this.splitOn(this.getParameterValueAsString(key), ";");
    }

    @Override
    public String getSubParameterValueAsString(ParameterKey key, String subParameterName) {
        if (StringUtils.isBlank((String)subParameterName)) {
            throw new RiceIllegalArgumentException("subParameterName is blank");
        }
        Collection<String> values = this.getParameterValuesAsString(key);
        return this.getSubParameter(values, subParameterName);
    }

    @Override
    public Collection<String> getSubParameterValuesAsString(ParameterKey key, String subParameterName) {
        return this.splitOn(this.getSubParameterValueAsString(key, subParameterName), ",");
    }

    private String getSubParameter(Collection<String> values, String subParameterName) {
        for (String value : values) {
            if (!subParameterName.equals(StringUtils.substringBefore((String)value, (String)SUB_PARAM_SEPARATOR))) continue;
            return StringUtils.trimToNull((String)StringUtils.substringAfter((String)value, (String)SUB_PARAM_SEPARATOR));
        }
        return null;
    }

    private Collection<String> splitOn(String strValues, String delim) {
        if (StringUtils.isEmpty((String)delim)) {
            throw new RiceIllegalArgumentException("delim is empty");
        }
        if (strValues == null || StringUtils.isBlank((String)strValues)) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String value : strValues.split(delim)) {
            values.add(value.trim());
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public ParameterQueryResults findParameters(QueryByCriteria queryByCriteria) {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria is null");
        }
        GenericQueryResults results = this.criteriaLookupService.lookup(ParameterBo.class, queryByCriteria);
        ParameterQueryResults.Builder builder = ParameterQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Parameter> ims = new ArrayList<Parameter>();
        for (ParameterBo bo : results.getResults()) {
            ims.add(ParameterBo.to(bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }
}

