/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.web.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.coreservice.impl.component.DerivedComponentBo;
import org.kuali.kfs.coreservice.impl.parameter.ParameterBo;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class ParameterLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 4381873774407301041L;
    private static final Log LOG = LogFactory.getLog(ParameterLookupableHelperServiceImpl.class);
    private static final String COMPONENT_NAME = "component.name";
    private static final String COMPONENT_CODE = "componentCode";

    @Override
    protected boolean allowsMaintenanceEditAction(BusinessObject businessObject) {
        ParameterBo parm = (ParameterBo)businessObject;
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", parm.getNamespaceCode());
        permissionDetails.put("componentName", parm.getComponentCode());
        permissionDetails.put("parameterName", parm.getName());
        return KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "KR-NS", "Maintain System Parameter", permissionDetails, Collections.emptyMap());
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        if (fieldValues.containsKey(COMPONENT_NAME) && fieldValues.containsKey(COMPONENT_CODE)) {
            fieldValues.remove(COMPONENT_CODE);
            fieldValues.put(COMPONENT_CODE, "");
        }
        String componentNameFieldValue = fieldValues.get(COMPONENT_NAME);
        fieldValues.remove(COMPONENT_NAME);
        List<? extends BusinessObject> results = super.getSearchResultsUnbounded(fieldValues);
        this.normalizeParameterComponents(results);
        if (!StringUtils.isBlank((String)componentNameFieldValue)) {
            componentNameFieldValue = componentNameFieldValue.trim();
            componentNameFieldValue = componentNameFieldValue.replace("*", ".*");
            componentNameFieldValue = ".*" + componentNameFieldValue + ".*";
            Pattern pattern = Pattern.compile(componentNameFieldValue, 2);
            Iterator<? extends BusinessObject> resultsIter = results.iterator();
            while (resultsIter.hasNext()) {
                ParameterBo result = (ParameterBo)resultsIter.next();
                if (result.getComponent() != null && pattern.matcher(result.getComponent().getName()).matches()) continue;
                resultsIter.remove();
            }
        }
        return results;
    }

    private void normalizeParameterComponents(List<ParameterBo> parameters) {
        for (ParameterBo parameterBo : parameters) {
            if (parameterBo.getComponent() != null) continue;
            parameterBo.setComponent(DerivedComponentBo.toComponentBo(parameterBo.getDerivedComponent()));
        }
    }
}

