/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.kns.service.CfAuthenticationService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CfAuthenticationServiceImpl
implements CfAuthenticationService {
    private static final Logger LOG = Logger.getLogger(CfAuthenticationServiceImpl.class);
    private IdentityService identityService;
    private PermissionService permissionService;

    @Override
    public AuthenticationValidationResponse validatePrincipalName(String principalName) {
        LOG.debug((Object)"validatePrincipalName() started");
        if (StringUtils.isBlank((String)principalName)) {
            return AuthenticationValidationResponse.INVALID_PRINCIPAL_NAME_BLANK;
        }
        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName);
        if (principal == null) {
            return AuthenticationValidationResponse.INVALID_PRINCIPAL_DOES_NOT_EXIST;
        }
        if (!this.isAuthorizedToLogin(principal.getPrincipalId())) {
            return AuthenticationValidationResponse.INVALID_PRINCIPAL_CANNOT_LOGIN;
        }
        return AuthenticationValidationResponse.VALID_AUTHENTICATION;
    }

    protected boolean isAuthorizedToLogin(String principalId) {
        return this.getPermissionService().isAuthorized(principalId, "KUALI", "Log In Kuali Portal", Collections.singletonMap("principalId", principalId));
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }
}

