/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation;

import java.util.List;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.BaseAttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.DataTypeConstraint;

public class SingleAttributeValueReader
extends BaseAttributeValueReader {
    private Object value;
    private AttributeDefinition definition;

    public SingleAttributeValueReader(Object value, String entryName, String attributeName, AttributeDefinition definition) {
        this.value = value;
        this.entryName = entryName;
        this.attributeName = attributeName;
        this.definition = definition;
    }

    @Override
    public Constrainable getDefinition(String attributeName) {
        return this.definition != null && this.definition.getName() != null && this.definition.getName().equals(attributeName) ? this.definition : null;
    }

    @Override
    public List<Constrainable> getDefinitions() {
        return null;
    }

    @Override
    public Constrainable getEntry() {
        return null;
    }

    @Override
    public String getLabel(String attributeName) {
        if (this.definition != null && this.definition.getName() != null && this.definition.getName().equals(attributeName)) {
            return this.definition.getLabel();
        }
        return attributeName;
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public String getPath() {
        return this.attributeName;
    }

    @Override
    public Class<?> getType(String selectedAttributeName) {
        DataTypeConstraint dataTypeConstraint;
        Constrainable attributeDefinition = this.getDefinition(selectedAttributeName);
        if (attributeDefinition != null && attributeDefinition instanceof DataTypeConstraint && (dataTypeConstraint = (DataTypeConstraint)((Object)attributeDefinition)).getDataType() != null) {
            return dataTypeConstraint.getDataType().getType();
        }
        return this.value != null ? this.value.getClass() : null;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public <X> X getValue() throws AttributeValidationException {
        return (X)this.value;
    }

    @Override
    public <X> X getValue(String attributeName) throws AttributeValidationException {
        Constrainable attributeDefinition = this.getDefinition(attributeName);
        if (attributeDefinition != null) {
            return (X)this.value;
        }
        return null;
    }

    @Override
    public AttributeValueReader clone() {
        SingleAttributeValueReader clone = new SingleAttributeValueReader(this.value, this.entryName, this.attributeName, this.definition);
        clone.setAttributeName(this.attributeName);
        return clone;
    }
}

