/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.AllowCharacterConstraint;

public class AlphaNumericPatternConstraint
extends AllowCharacterConstraint {
    protected boolean lowerCase = false;
    protected boolean upperCase = false;

    @Override
    public String getLabelKey() {
        if (StringUtils.isEmpty((String)this.labelKey)) {
            StringBuilder key = new StringBuilder("");
            if (this.lowerCase) {
                return "validation.alphanumericPatternLowerCase";
            }
            if (this.upperCase) {
                return "validation.alphanumericPatternUpperCase";
            }
            return "validation.alphanumericPattern";
        }
        return this.labelKey;
    }

    @Override
    public void setLabelKey(String labelKey) {
        super.setLabelKey(labelKey);
    }

    @Override
    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder("[A-Za-z0-9");
        if (this.lowerCase) {
            regexString = new StringBuilder("[a-z0-9");
        } else if (this.upperCase) {
            regexString = new StringBuilder("[A-Z0-9");
        }
        regexString.append(this.getAllowedCharacterRegex());
        regexString.append("]");
        return regexString.toString();
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

