/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidCharactersPatternConstraint;

public class CharsetPatternConstraint
extends ValidCharactersPatternConstraint {
    protected String validChars;

    public String getValidChars() {
        return this.validChars;
    }

    public void setValidChars(String validChars) {
        if (StringUtils.isEmpty((String)validChars)) {
            throw new IllegalArgumentException("invalid (empty) validChars");
        }
        this.validChars = validChars;
    }

    @Override
    protected String getRegexString() {
        if (StringUtils.isEmpty((String)this.validChars)) {
            throw new IllegalStateException("validChars is empty");
        }
        Pattern filteringChars = Pattern.compile("([\\-\\[\\]\\{\\}\\$\\.\\^\\(\\)\\*\\&\\|])");
        String filteredChars = filteringChars.matcher(this.validChars).replaceAll("\\\\$1");
        StringBuffer regexString = new StringBuffer("[");
        regexString.append(filteredChars);
        if (filteredChars.endsWith("\\")) {
            regexString.append("\\");
        }
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public String getLabelKey() {
        String labelKey = super.getLabelKey();
        if (StringUtils.isNotEmpty((String)labelKey)) {
            return labelKey;
        }
        return "validation.charsetPattern";
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            if (StringUtils.isNotBlank((String)this.validChars)) {
                this.validationMessageParams.add(this.validChars);
            }
        }
        return this.validationMessageParams;
    }
}

