/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.processor;

import java.math.BigDecimal;
import java.util.Date;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.RangeConstraint;
import org.kuali.kfs.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.kfs.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.ProcessorResult;
import org.kuali.rice.core.api.data.DataType;

public class RangeConstraintProcessor
extends MandatoryElementConstraintProcessor<RangeConstraint> {
    private static final String CONSTRAINT_NAME = "range constraint";
    private static final String MIN_EXCLUSIVE_KEY = "validation.minExclusive";
    private static final String MAX_INCLUSIVE_KEY = "validation.maxInclusive";
    private static final String RANGE_KEY = "validation.range";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, RangeConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        return new ProcessorResult(this.processSingleRangeConstraint(result, value, constraint, attributeValueReader));
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return RangeConstraint.class;
    }

    protected ConstraintValidationResult processSingleRangeConstraint(DictionaryValidationResult result, Object value, RangeConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        if (ValidationUtils.isNullOrEmpty(value) || constraint.getExclusiveMin() == null && constraint.getInclusiveMax() == null) {
            return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
        }
        DataType dataType = constraint.getDataType();
        Object typedValue = value;
        if (dataType != null) {
            typedValue = ValidationUtils.convertToDataType(value, dataType, this.dateTimeService);
        } else if (value instanceof String) {
            try {
                Double d = Double.parseDouble((String)value);
                typedValue = d;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (typedValue instanceof Date) {
            return this.validateRange(result, (Date)typedValue, constraint, attributeValueReader);
        }
        if (typedValue instanceof Number) {
            return this.validateRange(result, (Number)typedValue, constraint, attributeValueReader);
        }
        return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
    }

    protected ConstraintValidationResult validateRange(DictionaryValidationResult result, Date value, RangeConstraint constraint, AttributeValueReader attributeValueReader) throws IllegalArgumentException {
        Date date = value != null ? ValidationUtils.getDate(value, this.dateTimeService) : null;
        String inclusiveMaxText = constraint.getInclusiveMax();
        String exclusiveMinText = constraint.getExclusiveMin();
        Date inclusiveMax = inclusiveMaxText != null ? ValidationUtils.getDate(inclusiveMaxText, this.dateTimeService) : null;
        Date exclusiveMin = exclusiveMinText != null ? ValidationUtils.getDate(exclusiveMinText, this.dateTimeService) : null;
        return this.isInRange(result, date, inclusiveMax, inclusiveMaxText, exclusiveMin, exclusiveMinText, attributeValueReader);
    }

    protected ConstraintValidationResult validateRange(DictionaryValidationResult result, Number value, RangeConstraint constraint, AttributeValueReader attributeValueReader) throws IllegalArgumentException {
        BigDecimal number = value != null ? new BigDecimal(value.toString()) : null;
        String inclusiveMaxText = constraint.getInclusiveMax();
        String exclusiveMinText = constraint.getExclusiveMin();
        BigDecimal inclusiveMax = inclusiveMaxText != null ? new BigDecimal(inclusiveMaxText) : null;
        BigDecimal exclusiveMin = exclusiveMinText != null ? new BigDecimal(exclusiveMinText) : null;
        return this.isInRange(result, number, inclusiveMax, inclusiveMaxText, exclusiveMin, exclusiveMinText, attributeValueReader);
    }

    private <T> ConstraintValidationResult isInRange(DictionaryValidationResult result, T value, Comparable<T> inclusiveMax, String inclusiveMaxText, Comparable<T> exclusiveMin, String exclusiveMinText, AttributeValueReader attributeValueReader) {
        ValidationUtils.Result lessThanMax = ValidationUtils.isLessThanOrEqual(value, inclusiveMax);
        ValidationUtils.Result greaterThanMin = ValidationUtils.isGreaterThan(value, exclusiveMin);
        if (lessThanMax != ValidationUtils.Result.INVALID && greaterThanMin != ValidationUtils.Result.INVALID) {
            if (lessThanMax == ValidationUtils.Result.UNDEFINED && greaterThanMin == ValidationUtils.Result.UNDEFINED) {
                return result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME);
            }
            return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
        }
        if (lessThanMax != ValidationUtils.Result.UNDEFINED && greaterThanMin != ValidationUtils.Result.UNDEFINED) {
            return result.addError(RANGE_KEY, attributeValueReader, CONSTRAINT_NAME, "error.outOfRange", exclusiveMinText, inclusiveMaxText);
        }
        if (lessThanMax == ValidationUtils.Result.INVALID) {
            return result.addError(MAX_INCLUSIVE_KEY, attributeValueReader, CONSTRAINT_NAME, "error.inclusiveMax", inclusiveMaxText);
        }
        return result.addError(MIN_EXCLUSIVE_KEY, attributeValueReader, CONSTRAINT_NAME, "error.exclusiveMin", exclusiveMinText);
    }
}

