/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.maintenance;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.krad.document.DocumentViewAuthorizerBase;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.kim.api.identity.Person;

public class MaintenanceViewAuthorizerBase
extends DocumentViewAuthorizerBase {
    private static final long serialVersionUID = 8688732738163609576L;

    public final boolean canCreate(Class<?> boClass, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(boClass));
        permissionDetails.put("maintenanceAction", "New");
        return !this.permissionExistsByTemplate("KR-NS", "Create / Maintain Record(s)", permissionDetails) || MaintenanceViewAuthorizerBase.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "Create / Maintain Record(s)", permissionDetails, new HashMap());
    }

    public final boolean canMaintain(Object dataObject, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>(2);
        permissionDetails.put("documentTypeName", KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObject.getClass()));
        permissionDetails.put("maintenanceAction", "Edit");
        return !this.permissionExistsByTemplate("KR-NS", "Create / Maintain Record(s)", permissionDetails) || this.isAuthorizedByTemplate(dataObject, "KR-NS", "Create / Maintain Record(s)", user.getPrincipalId(), permissionDetails, null);
    }

    public final boolean canCreateOrMaintain(MaintenanceDocument maintenanceDocument, Person user) {
        return !this.permissionExistsByTemplate(maintenanceDocument, "KR-NS", "Create / Maintain Record(s)") || this.isAuthorizedByTemplate(maintenanceDocument, "KR-NS", "Create / Maintain Record(s)", user.getPrincipalId());
    }

    @Override
    protected void addRoleQualification(Object dataObject, Map<String, String> attributes) {
        MaintenanceDocument maintDoc;
        super.addRoleQualification(dataObject, attributes);
        if (dataObject instanceof MaintenanceDocument && (maintDoc = (MaintenanceDocument)dataObject).getNewMaintainableObject() != null) {
            attributes.putAll(KRADUtils.getNamespaceAndComponentSimpleName(maintDoc.getNewMaintainableObject().getDataObjectClass()));
        }
    }

    @Override
    protected void addPermissionDetails(Object dataObject, Map<String, String> attributes) {
        MaintenanceDocument maintDoc;
        super.addPermissionDetails(dataObject, attributes);
        if (dataObject instanceof MaintenanceDocument && (maintDoc = (MaintenanceDocument)dataObject).getNewMaintainableObject() != null) {
            attributes.putAll(KRADUtils.getNamespaceAndComponentSimpleName(maintDoc.getNewMaintainableObject().getDataObjectClass()));
            attributes.put("maintenanceAction", maintDoc.getNewMaintainableObject().getMaintenanceAction());
        }
    }
}

