/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.exception.InvalidAddressException;
import org.kuali.kfs.krad.service.MailService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.mail.EmailBcList;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailCcList;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailToList;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;

public class MailServiceImpl
implements MailService {
    private static Logger LOG = Logger.getLogger(MailServiceImpl.class);
    protected Mailer mailer;
    protected String batchMailingList;
    protected String nonProductionNotificationMailingList;
    protected boolean realNotificationsEnabled = true;
    protected ConfigurationService configurationService;

    @Override
    public void sendMessage(MailMessage message) throws InvalidAddressException, MessagingException {
        LOG.debug((Object)"sendMessage() started");
        this.sendMessage(message, false);
    }

    @Override
    public void sendMessage(MailMessage message, boolean htmlMessage) throws InvalidAddressException, MessagingException {
        LOG.debug((Object)"sendMessage() started");
        MailMessage mm = this.modifyForNonProduction(message, htmlMessage);
        mm.setSubject(this.messageSubject(message.getSubject()));
        ArrayList bccAddresses = new ArrayList();
        bccAddresses.addAll(mm.getBccAddresses());
        ArrayList ccAddresses = new ArrayList();
        ccAddresses.addAll(mm.getCcAddresses());
        ArrayList toAddresses = new ArrayList();
        toAddresses.addAll(mm.getToAddresses());
        this.mailer.sendEmail(new EmailFrom(mm.getFromAddress()), new EmailToList(toAddresses), new EmailSubject(mm.getSubject()), new EmailBody(mm.getMessage()), new EmailCcList(ccAddresses), new EmailBcList(bccAddresses), htmlMessage);
    }

    @Override
    public String getBatchMailingList() {
        LOG.debug((Object)"getBatchMailingList() started");
        if (this.realNotificationsEnabled) {
            return this.batchMailingList;
        }
        return this.nonProductionNotificationMailingList;
    }

    protected String messageSubject(String subject) {
        String app = this.configurationService.getPropertyValueAsString("application.id");
        String env = this.configurationService.getPropertyValueAsString("application.url");
        return app + " " + env + ": " + subject;
    }

    protected MailMessage modifyForNonProduction(MailMessage originalMessage, boolean htmlMessage) {
        if (this.realNotificationsEnabled) {
            return originalMessage;
        }
        MailMessage modifiedMessage = new MailMessage();
        modifiedMessage.setFromAddress(originalMessage.getFromAddress());
        modifiedMessage.setSubject(originalMessage.getSubject());
        StringBuilder buf = new StringBuilder();
        String newLine = htmlMessage ? "<br/>\n" : "\n";
        buf.append("Email To: ").append(originalMessage.getToAddresses()).append(newLine);
        buf.append("Email CC: ").append(originalMessage.getCcAddresses()).append(newLine);
        buf.append("Email BCC: ").append(originalMessage.getBccAddresses()).append(newLine + newLine);
        buf.append(originalMessage.getMessage());
        modifiedMessage.setMessage(buf.toString());
        modifiedMessage.addToAddress(this.nonProductionNotificationMailingList);
        return modifiedMessage;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public void setRealNotificationsEnabled(boolean realNotificationsEnabled) {
        this.realNotificationsEnabled = realNotificationsEnabled;
    }

    public void setNonProductionNotificationMailingList(String nonProductionNotificationMailingList) {
        this.nonProductionNotificationMailingList = nonProductionNotificationMailingList;
    }

    public void setBatchMailingList(String batchMailingList) {
        this.batchMailingList = batchMailingList;
    }
}

