/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.KualiCode;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.mask.MaskFormatter;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ComponentSecurity;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.field.DataFieldSecurity;
import org.kuali.kfs.krad.uif.field.FieldBase;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.Inquiry;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.valuefinder.ValueFinder;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

public class DataField
extends FieldBase
implements DataBinding {
    private static final long serialVersionUID = -4129678891948564724L;
    private String propertyName;
    private BindingInfo bindingInfo;
    private String dictionaryAttributeName;
    private String dictionaryObjectEntry;
    private String defaultValue;
    private Class<? extends ValueFinder> defaultValueFinderClass;
    private PropertyEditor propertyEditor;
    private boolean readOnlyHidden = false;
    protected String alternateDisplayPropertyName;
    protected String additionalDisplayPropertyName;
    private String alternateDisplayValue;
    private String additionalDisplayValue;
    private boolean applyValueMask = false;
    private MaskFormatter maskFormatter;
    private List<String> hiddenPropertyNames = new ArrayList<String>();
    private List<String> informationalDisplayPropertyNames = new ArrayList<String>();
    private boolean escapeHtmlInPropertyValue = true;
    private String helpSummary;
    private String helpDescription;
    private Inquiry fieldInquiry;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.isReadOnlyHidden()) {
            this.setReadOnly(true);
            this.getHiddenPropertyNames().add(this.getPropertyName());
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        ArrayList<String> hiddenPropertyPaths = new ArrayList<String>();
        for (String hiddenPropertyName : this.getHiddenPropertyNames()) {
            String hiddenPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(hiddenPropertyName);
            hiddenPropertyPaths.add(hiddenPropertyPath);
        }
        this.hiddenPropertyNames = hiddenPropertyPaths;
        ArrayList<String> informationalPropertyPaths = new ArrayList<String>();
        for (String infoPropertyName : this.getInformationalDisplayPropertyNames()) {
            String infoPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(infoPropertyName);
            informationalPropertyPaths.add(infoPropertyPath);
        }
        this.informationalDisplayPropertyNames = informationalPropertyPaths;
        this.setAlternateAndAdditionalDisplayValue(view, model);
    }

    protected void setAlternateAndAdditionalDisplayValue(View view, Object model) {
        String additionalDisplayPropertyPath;
        Object additionalFieldValue;
        String alternateDisplayPropertyPath;
        Object alternateFieldValue;
        if (StringUtils.isNotBlank((String)this.alternateDisplayValue) || StringUtils.isNotBlank((String)this.additionalDisplayValue)) {
            return;
        }
        if (this.isApplyValueMask()) {
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath());
            this.alternateDisplayValue = this.getMaskFormatter().maskValue(fieldValue);
            this.setReadOnly(true);
            return;
        }
        if (!this.isReadOnly()) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.getAlternateDisplayPropertyName()) && (alternateFieldValue = ObjectPropertyUtils.getPropertyValue(model, alternateDisplayPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(this.getAlternateDisplayPropertyName()))) != null) {
            this.alternateDisplayValue = alternateFieldValue.toString();
        }
        if (StringUtils.isBlank((String)this.getAdditionalDisplayPropertyName()) && view.isTranslateCodes()) {
            Class<?> parentObjectClass = ViewModelUtils.getParentObjectClassForMetadata(view, model, this);
            DataObjectRelationship relationship = KRADServiceLocatorWeb.getDataObjectMetaDataService().getDataObjectRelationship(null, parentObjectClass, this.getBindingInfo().getBindingName(), "", true, false, false);
            if (relationship != null && this.getPropertyName().startsWith(relationship.getParentAttributeName()) && KualiCode.class.isAssignableFrom(relationship.getRelatedClass())) {
                this.additionalDisplayPropertyName = relationship.getParentAttributeName() + "." + "name";
            }
        }
        if (StringUtils.isNotBlank((String)this.getAdditionalDisplayPropertyName()) && (additionalFieldValue = ObjectPropertyUtils.getPropertyValue(model, additionalDisplayPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(this.getAdditionalDisplayPropertyName()))) != null) {
            this.additionalDisplayValue = additionalFieldValue.toString();
        }
    }

    public void copyFromAttributeDefinition(View view, AttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)this.getLabel())) {
            this.setLabel(attributeDefinition.getLabel());
        }
        if (StringUtils.isEmpty((String)this.getShortLabel())) {
            this.setShortLabel(attributeDefinition.getShortLabel());
        }
        if (StringUtils.isEmpty((String)this.getHelpSummary())) {
            this.setHelpSummary(attributeDefinition.getSummary());
        }
        if (StringUtils.isEmpty((String)this.getHelpDescription())) {
            this.setHelpDescription(attributeDefinition.getDescription());
        }
        if (this.getDataFieldSecurity().getAttributeSecurity() == null) {
            this.getDataFieldSecurity().setAttributeSecurity(attributeDefinition.getAttributeSecurity());
        }
        if (this.getAlternateDisplayPropertyName() == null && StringUtils.isNotBlank((String)attributeDefinition.getAlternateDisplayAttributeName())) {
            this.setAlternateDisplayPropertyName(attributeDefinition.getAlternateDisplayAttributeName());
        }
        if (this.getAdditionalDisplayPropertyName() == null && StringUtils.isNotBlank((String)attributeDefinition.getAdditionalDisplayAttributeName())) {
            this.setAdditionalDisplayPropertyName(attributeDefinition.getAdditionalDisplayAttributeName());
        }
        if (this.getPropertyEditor() == null) {
            this.setPropertyEditor(attributeDefinition.getPropertyEditor());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.fieldInquiry);
        return components;
    }

    public boolean isInputAllowed() {
        return false;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setPropertyEditorClass(Class<? extends PropertyEditor> propertyEditorClass) {
        this.propertyEditor = ObjectUtils.newInstance(propertyEditorClass);
    }

    @Override
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public String getDictionaryAttributeName() {
        return this.dictionaryAttributeName;
    }

    public void setDictionaryAttributeName(String dictionaryAttributeName) {
        this.dictionaryAttributeName = dictionaryAttributeName;
    }

    public String getDictionaryObjectEntry() {
        return this.dictionaryObjectEntry;
    }

    public void setDictionaryObjectEntry(String dictionaryObjectEntry) {
        this.dictionaryObjectEntry = dictionaryObjectEntry;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Class<? extends ValueFinder> getDefaultValueFinderClass() {
        return this.defaultValueFinderClass;
    }

    public void setDefaultValueFinderClass(Class<? extends ValueFinder> defaultValueFinderClass) {
        this.defaultValueFinderClass = defaultValueFinderClass;
    }

    public String getHelpSummary() {
        return this.helpSummary;
    }

    public void setHelpSummary(String helpSummary) {
        this.helpSummary = helpSummary;
    }

    public String getHelpDescription() {
        return this.helpDescription;
    }

    public void setHelpDescription(String helpDescription) {
        this.helpDescription = helpDescription;
    }

    public DataFieldSecurity getDataFieldSecurity() {
        return (DataFieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (!(componentSecurity instanceof DataFieldSecurity)) {
            throw new RiceRuntimeException("Component security for DataField should be instance of DataFieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return DataFieldSecurity.class;
    }

    public boolean isReadOnlyHidden() {
        return this.readOnlyHidden;
    }

    public void setReadOnlyHidden(boolean readOnlyHidden) {
        this.readOnlyHidden = readOnlyHidden;
    }

    public Inquiry getFieldInquiry() {
        return this.fieldInquiry;
    }

    public void setFieldInquiry(Inquiry fieldInquiry) {
        this.fieldInquiry = fieldInquiry;
    }

    public void setAdditionalDisplayPropertyName(String additionalDisplayPropertyName) {
        this.additionalDisplayPropertyName = additionalDisplayPropertyName;
    }

    public String getAdditionalDisplayPropertyName() {
        return this.additionalDisplayPropertyName;
    }

    public void setAlternateDisplayPropertyName(String alternateDisplayPropertyName) {
        this.alternateDisplayPropertyName = alternateDisplayPropertyName;
    }

    public String getAlternateDisplayPropertyName() {
        return this.alternateDisplayPropertyName;
    }

    public String getAlternateDisplayValue() {
        return this.alternateDisplayValue;
    }

    public void setAlternateDisplayValue(String value) {
        this.alternateDisplayValue = value;
    }

    public String getAdditionalDisplayValue() {
        return this.additionalDisplayValue;
    }

    public void setAdditionalDisplayValue(String value) {
        this.additionalDisplayValue = value;
    }

    public boolean isApplyValueMask() {
        return this.applyValueMask;
    }

    public void setApplyValueMask(boolean applyValueMask) {
        this.applyValueMask = applyValueMask;
    }

    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }

    public List<String> getHiddenPropertyNames() {
        return this.hiddenPropertyNames;
    }

    public void setHiddenPropertyNames(List<String> hiddenPropertyNames) {
        this.hiddenPropertyNames = hiddenPropertyNames;
    }

    public List<String> getInformationalDisplayPropertyNames() {
        return this.informationalDisplayPropertyNames;
    }

    public void setInformationalDisplayPropertyNames(List<String> informationalDisplayPropertyNames) {
        this.informationalDisplayPropertyNames = informationalDisplayPropertyNames;
    }

    public void setEscapeHtmlInPropertyValue(boolean escapeHtmlInPropertyValue) {
        this.escapeHtmlInPropertyValue = escapeHtmlInPropertyValue;
    }

    public boolean isEscapeHtmlInPropertyValue() {
        return this.escapeHtmlInPropertyValue;
    }

    public boolean hasSecureValue() {
        return this.isApplyValueMask() || (this.getComponentSecurity().isViewAuthz() || this.getDataFieldSecurity().isViewInLineAuthz() || this.getDataFieldSecurity().getAttributeSecurity() != null && this.getDataFieldSecurity().getAttributeSecurity().isHide()) && this.isHidden();
    }
}

